# openapi_client.DynamicLocationActionsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**dynamic_location_actions_dynamic_location_action_id_delete**](DynamicLocationActionsApi.md#dynamic_location_actions_dynamic_location_action_id_delete) | **DELETE** /dynamic-location-actions/{dynamic_location_action_id} | 
[**dynamic_location_actions_dynamic_location_action_id_get**](DynamicLocationActionsApi.md#dynamic_location_actions_dynamic_location_action_id_get) | **GET** /dynamic-location-actions/{dynamic_location_action_id} | 
[**dynamic_location_actions_dynamic_location_action_id_patch**](DynamicLocationActionsApi.md#dynamic_location_actions_dynamic_location_action_id_patch) | **PATCH** /dynamic-location-actions/{dynamic_location_action_id} | 
[**dynamic_location_actions_get**](DynamicLocationActionsApi.md#dynamic_location_actions_get) | **GET** /dynamic-location-actions | 
[**dynamic_location_actions_post**](DynamicLocationActionsApi.md#dynamic_location_actions_post) | **POST** /dynamic-location-actions | 


# **dynamic_location_actions_dynamic_location_action_id_delete**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response dynamic_location_actions_dynamic_location_action_id_delete(dynamic_location_action_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DynamicLocationActionsApi(api_client)
    dynamic_location_action_id = 'dynamic_location_action_id_example' # str | 

    try:
        api_response = api_instance.dynamic_location_actions_dynamic_location_action_id_delete(dynamic_location_action_id)
        print("The response of DynamicLocationActionsApi->dynamic_location_actions_dynamic_location_action_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DynamicLocationActionsApi->dynamic_location_actions_dynamic_location_action_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dynamic_location_action_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **dynamic_location_actions_dynamic_location_action_id_get**
> DynamicLocationActionsPost201Response dynamic_location_actions_dynamic_location_action_id_get(dynamic_location_action_id, include=include)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.dynamic_location_actions_post201_response import DynamicLocationActionsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DynamicLocationActionsApi(api_client)
    dynamic_location_action_id = 'dynamic_location_action_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.dynamic_location_actions_dynamic_location_action_id_get(dynamic_location_action_id, include=include)
        print("The response of DynamicLocationActionsApi->dynamic_location_actions_dynamic_location_action_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DynamicLocationActionsApi->dynamic_location_actions_dynamic_location_action_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dynamic_location_action_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**DynamicLocationActionsPost201Response**](DynamicLocationActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a dynamic location action |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **dynamic_location_actions_dynamic_location_action_id_patch**
> DynamicLocationActionsPost201Response dynamic_location_actions_dynamic_location_action_id_patch(dynamic_location_action_id, dynamic_location_actions_dynamic_location_action_id_patch_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.dynamic_location_actions_dynamic_location_action_id_patch_request import DynamicLocationActionsDynamicLocationActionIdPatchRequest
from openapi_client.models.dynamic_location_actions_post201_response import DynamicLocationActionsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DynamicLocationActionsApi(api_client)
    dynamic_location_action_id = 'dynamic_location_action_id_example' # str | 
    dynamic_location_actions_dynamic_location_action_id_patch_request = openapi_client.DynamicLocationActionsDynamicLocationActionIdPatchRequest() # DynamicLocationActionsDynamicLocationActionIdPatchRequest | Dynamic location action attributes

    try:
        api_response = api_instance.dynamic_location_actions_dynamic_location_action_id_patch(dynamic_location_action_id, dynamic_location_actions_dynamic_location_action_id_patch_request)
        print("The response of DynamicLocationActionsApi->dynamic_location_actions_dynamic_location_action_id_patch:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DynamicLocationActionsApi->dynamic_location_actions_dynamic_location_action_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dynamic_location_action_id** | **str**|  | 
 **dynamic_location_actions_dynamic_location_action_id_patch_request** | [**DynamicLocationActionsDynamicLocationActionIdPatchRequest**](DynamicLocationActionsDynamicLocationActionIdPatchRequest.md)| Dynamic location action attributes | 

### Return type

[**DynamicLocationActionsPost201Response**](DynamicLocationActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated dynamic location action |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **dynamic_location_actions_get**
> DynamicLocationActionsGet200Response dynamic_location_actions_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_begin_date=filter_begin_date, filter_end_date=filter_end_date, filter_begin_description=filter_begin_description, filter_end_description=filter_end_description, filter_label=filter_label, filter_epsg_code=filter_epsg_code, filter_elevation_datum_name=filter_elevation_datum_name, filter_elevation_datum_uri=filter_elevation_datum_uri, filter_configuration_id=filter_configuration_id, filter_x_property_id=filter_x_property_id, filter_y_property_id=filter_y_property_id, filter_z_property_id=filter_z_property_id, filter=filter)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.dynamic_location_actions_get200_response import DynamicLocationActionsGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DynamicLocationActionsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_begin_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_begin_description = 'filter_begin_description_example' # str |  (optional)
    filter_end_description = 'filter_end_description_example' # str |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_epsg_code = 'filter_epsg_code_example' # str |  (optional)
    filter_elevation_datum_name = 'filter_elevation_datum_name_example' # str |  (optional)
    filter_elevation_datum_uri = 'filter_elevation_datum_uri_example' # str |  (optional)
    filter_configuration_id = 'filter_configuration_id_example' # str |  (optional)
    filter_x_property_id = 'filter_x_property_id_example' # str |  (optional)
    filter_y_property_id = 'filter_y_property_id_example' # str |  (optional)
    filter_z_property_id = 'filter_z_property_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.dynamic_location_actions_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_begin_date=filter_begin_date, filter_end_date=filter_end_date, filter_begin_description=filter_begin_description, filter_end_description=filter_end_description, filter_label=filter_label, filter_epsg_code=filter_epsg_code, filter_elevation_datum_name=filter_elevation_datum_name, filter_elevation_datum_uri=filter_elevation_datum_uri, filter_configuration_id=filter_configuration_id, filter_x_property_id=filter_x_property_id, filter_y_property_id=filter_y_property_id, filter_z_property_id=filter_z_property_id, filter=filter)
        print("The response of DynamicLocationActionsApi->dynamic_location_actions_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DynamicLocationActionsApi->dynamic_location_actions_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_begin_date** | **datetime**|  | [optional] 
 **filter_end_date** | **datetime**|  | [optional] 
 **filter_begin_description** | **str**|  | [optional] 
 **filter_end_description** | **str**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_epsg_code** | **str**|  | [optional] 
 **filter_elevation_datum_name** | **str**|  | [optional] 
 **filter_elevation_datum_uri** | **str**|  | [optional] 
 **filter_configuration_id** | **str**|  | [optional] 
 **filter_x_property_id** | **str**|  | [optional] 
 **filter_y_property_id** | **str**|  | [optional] 
 **filter_z_property_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**DynamicLocationActionsGet200Response**](DynamicLocationActionsGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api.json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of dynamic locations |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **dynamic_location_actions_post**
> DynamicLocationActionsPost201Response dynamic_location_actions_post(dynamic_location_actions_post_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.dynamic_location_actions_post201_response import DynamicLocationActionsPost201Response
from openapi_client.models.dynamic_location_actions_post_request import DynamicLocationActionsPostRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.DynamicLocationActionsApi(api_client)
    dynamic_location_actions_post_request = openapi_client.DynamicLocationActionsPostRequest() # DynamicLocationActionsPostRequest | 

    try:
        api_response = api_instance.dynamic_location_actions_post(dynamic_location_actions_post_request)
        print("The response of DynamicLocationActionsApi->dynamic_location_actions_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DynamicLocationActionsApi->dynamic_location_actions_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dynamic_location_actions_post_request** | [**DynamicLocationActionsPostRequest**](DynamicLocationActionsPostRequest.md)|  | 

### Return type

[**DynamicLocationActionsPost201Response**](DynamicLocationActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api.json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created dynamic location action |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

