# openapi_client.ExportControlApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_export_control**](ExportControlApi.md#create_export_control) | **POST** /export-control | 
[**delete_export_control**](ExportControlApi.md#delete_export_control) | **DELETE** /export-control/{export_control_id} | 
[**retrieve_export_control_instance**](ExportControlApi.md#retrieve_export_control_instance) | **GET** /export-control/{export_control_id} | 
[**retrievecollectionof_export_controlobjects**](ExportControlApi.md#retrievecollectionof_export_controlobjects) | **GET** /export-control | 
[**update_export_control**](ExportControlApi.md#update_export_control) | **PATCH** /export-control/{export_control_id} | 


# **create_export_control**
> CreateExportControl201Response create_export_control(create_export_control_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_export_control201_response import CreateExportControl201Response
from openapi_client.models.create_export_control_request import CreateExportControlRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlApi(api_client)
    create_export_control_request = openapi_client.CreateExportControlRequest() # CreateExportControlRequest | 

    try:
        api_response = api_instance.create_export_control(create_export_control_request)
        print("The response of ExportControlApi->create_export_control:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlApi->create_export_control: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_export_control_request** | [**CreateExportControlRequest**](CreateExportControlRequest.md)|  | 

### Return type

[**CreateExportControl201Response**](CreateExportControl201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created export control information |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_export_control**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_export_control(export_control_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlApi(api_client)
    export_control_id = 'export_control_id_example' # str | 

    try:
        api_response = api_instance.delete_export_control(export_control_id)
        print("The response of ExportControlApi->delete_export_control:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlApi->delete_export_control: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **export_control_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_export_control_instance**
> CreateExportControl201Response retrieve_export_control_instance(export_control_id, include=include)

Retrieve a single export control information

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_export_control201_response import CreateExportControl201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlApi(api_client)
    export_control_id = 'export_control_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_export_control_instance(export_control_id, include=include)
        print("The response of ExportControlApi->retrieve_export_control_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlApi->retrieve_export_control_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **export_control_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateExportControl201Response**](CreateExportControl201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of export control information |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrievecollectionof_export_controlobjects**
> RetrievecollectionofExportControlobjects200Response retrievecollectionof_export_controlobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_dual_use=filter_dual_use, filter_export_control_classification_number=filter_export_control_classification_number, filter_customs_tariff_number=filter_customs_tariff_number, filter_additional_information=filter_additional_information, filter_internal_note=filter_internal_note, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_manufacturer_model_id=filter_manufacturer_model_id)

Retrieve a list of export control information

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrievecollectionof_export_controlobjects200_response import RetrievecollectionofExportControlobjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_dual_use = True # bool |  (optional)
    filter_export_control_classification_number = 'filter_export_control_classification_number_example' # str |  (optional)
    filter_customs_tariff_number = 'filter_customs_tariff_number_example' # str |  (optional)
    filter_additional_information = 'filter_additional_information_example' # str |  (optional)
    filter_internal_note = 'filter_internal_note_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_manufacturer_model_id = 'filter_manufacturer_model_id_example' # str |  (optional)

    try:
        api_response = api_instance.retrievecollectionof_export_controlobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_dual_use=filter_dual_use, filter_export_control_classification_number=filter_export_control_classification_number, filter_customs_tariff_number=filter_customs_tariff_number, filter_additional_information=filter_additional_information, filter_internal_note=filter_internal_note, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_manufacturer_model_id=filter_manufacturer_model_id)
        print("The response of ExportControlApi->retrievecollectionof_export_controlobjects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlApi->retrievecollectionof_export_controlobjects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_dual_use** | **bool**|  | [optional] 
 **filter_export_control_classification_number** | **str**|  | [optional] 
 **filter_customs_tariff_number** | **str**|  | [optional] 
 **filter_additional_information** | **str**|  | [optional] 
 **filter_internal_note** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_manufacturer_model_id** | **str**|  | [optional] 

### Return type

[**RetrievecollectionofExportControlobjects200Response**](RetrievecollectionofExportControlobjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of export control information |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_export_control**
> CreateExportControl201Response update_export_control(export_control_id, update_export_control_request)

Update ExportControl attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_export_control201_response import CreateExportControl201Response
from openapi_client.models.update_export_control_request import UpdateExportControlRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlApi(api_client)
    export_control_id = 'export_control_id_example' # str | 
    update_export_control_request = openapi_client.UpdateExportControlRequest() # UpdateExportControlRequest | Export control attributes

    try:
        api_response = api_instance.update_export_control(export_control_id, update_export_control_request)
        print("The response of ExportControlApi->update_export_control:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlApi->update_export_control: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **export_control_id** | **str**|  | 
 **update_export_control_request** | [**UpdateExportControlRequest**](UpdateExportControlRequest.md)| Export control attributes | 

### Return type

[**CreateExportControl201Response**](CreateExportControl201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated export control information |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

