# openapi_client.ExportControlAttachmentsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_export_control_attachment**](ExportControlAttachmentsApi.md#create_export_control_attachment) | **POST** /export-control-attachments | 
[**delete_export_control_attachment**](ExportControlAttachmentsApi.md#delete_export_control_attachment) | **DELETE** /export-control-attachments/{export_control_attachment_id} | 
[**export_control_attachments_export_control_attachment_id_file_filename_get**](ExportControlAttachmentsApi.md#export_control_attachments_export_control_attachment_id_file_filename_get) | **GET** /export-control-attachments/{export_control_attachment_id}/file/{filename} | 
[**retrieve_export_control_attachment_instance**](ExportControlAttachmentsApi.md#retrieve_export_control_attachment_instance) | **GET** /export-control-attachments/{export_control_attachment_id} | 
[**retrievecollectionof_export_control_attachmentobjects**](ExportControlAttachmentsApi.md#retrievecollectionof_export_control_attachmentobjects) | **GET** /export-control-attachments | 
[**update_export_control_attachment**](ExportControlAttachmentsApi.md#update_export_control_attachment) | **PATCH** /export-control-attachments/{export_control_attachment_id} | 


# **create_export_control_attachment**
> CreateExportControlAttachment201Response create_export_control_attachment(create_export_control_attachment_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_export_control_attachment201_response import CreateExportControlAttachment201Response
from openapi_client.models.create_export_control_attachment_request import CreateExportControlAttachmentRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlAttachmentsApi(api_client)
    create_export_control_attachment_request = openapi_client.CreateExportControlAttachmentRequest() # CreateExportControlAttachmentRequest | 

    try:
        api_response = api_instance.create_export_control_attachment(create_export_control_attachment_request)
        print("The response of ExportControlAttachmentsApi->create_export_control_attachment:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlAttachmentsApi->create_export_control_attachment: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_export_control_attachment_request** | [**CreateExportControlAttachmentRequest**](CreateExportControlAttachmentRequest.md)|  | 

### Return type

[**CreateExportControlAttachment201Response**](CreateExportControlAttachment201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created export control attachment |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_export_control_attachment**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_export_control_attachment(export_control_attachment_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlAttachmentsApi(api_client)
    export_control_attachment_id = 'export_control_attachment_id_example' # str | 

    try:
        api_response = api_instance.delete_export_control_attachment(export_control_attachment_id)
        print("The response of ExportControlAttachmentsApi->delete_export_control_attachment:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlAttachmentsApi->delete_export_control_attachment: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **export_control_attachment_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **export_control_attachments_export_control_attachment_id_file_filename_get**
> export_control_attachments_export_control_attachment_id_file_filename_get(export_control_attachment_id, filename)

Endpoint to get the content of the uploaded file.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlAttachmentsApi(api_client)
    export_control_attachment_id = 'export_control_attachment_id_example' # str | 
    filename = 'file' # str | Filename of the file. Can be arbitrary, it will always return the same file - no matter how this parameter is set. Backend needs this to allow linking of filenames for uploads. (default to 'file')

    try:
        api_instance.export_control_attachments_export_control_attachment_id_file_filename_get(export_control_attachment_id, filename)
    except Exception as e:
        print("Exception when calling ExportControlAttachmentsApi->export_control_attachments_export_control_attachment_id_file_filename_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **export_control_attachment_id** | **str**|  | 
 **filename** | **str**| Filename of the file. Can be arbitrary, it will always return the same file - no matter how this parameter is set. Backend needs this to allow linking of filenames for uploads. | [default to &#39;file&#39;]

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Content of the file. Content-Type is the same as the original upload. |  -  |
**401** | Authentification required. |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_export_control_attachment_instance**
> CreateExportControlAttachment201Response retrieve_export_control_attachment_instance(export_control_attachment_id, include=include)

Retrieve a single export control attachment

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_export_control_attachment201_response import CreateExportControlAttachment201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlAttachmentsApi(api_client)
    export_control_attachment_id = 'export_control_attachment_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_export_control_attachment_instance(export_control_attachment_id, include=include)
        print("The response of ExportControlAttachmentsApi->retrieve_export_control_attachment_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlAttachmentsApi->retrieve_export_control_attachment_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **export_control_attachment_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateExportControlAttachment201Response**](CreateExportControlAttachment201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of export control attachment |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrievecollectionof_export_control_attachmentobjects**
> RetrievecollectionofExportControlAttachmentobjects200Response retrievecollectionof_export_control_attachmentobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_url=filter_url, filter_description=filter_description, filter_is_upload=filter_is_upload, filter_is_export_control_only=filter_is_export_control_only, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_manufacturer_model_id=filter_manufacturer_model_id)

Retrieve a list of export control attachments

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrievecollectionof_export_control_attachmentobjects200_response import RetrievecollectionofExportControlAttachmentobjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlAttachmentsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_url = 'filter_url_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_is_upload = True # bool |  (optional)
    filter_is_export_control_only = True # bool |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_manufacturer_model_id = 'filter_manufacturer_model_id_example' # str |  (optional)

    try:
        api_response = api_instance.retrievecollectionof_export_control_attachmentobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_url=filter_url, filter_description=filter_description, filter_is_upload=filter_is_upload, filter_is_export_control_only=filter_is_export_control_only, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_manufacturer_model_id=filter_manufacturer_model_id)
        print("The response of ExportControlAttachmentsApi->retrievecollectionof_export_control_attachmentobjects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlAttachmentsApi->retrievecollectionof_export_control_attachmentobjects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_url** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_is_upload** | **bool**|  | [optional] 
 **filter_is_export_control_only** | **bool**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_manufacturer_model_id** | **str**|  | [optional] 

### Return type

[**RetrievecollectionofExportControlAttachmentobjects200Response**](RetrievecollectionofExportControlAttachmentobjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of export control attachments |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_export_control_attachment**
> CreateExportControlAttachment201Response update_export_control_attachment(export_control_attachment_id, update_export_control_attachment_request)

Update ExportControlAttachment attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_export_control_attachment201_response import CreateExportControlAttachment201Response
from openapi_client.models.update_export_control_attachment_request import UpdateExportControlAttachmentRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ExportControlAttachmentsApi(api_client)
    export_control_attachment_id = 'export_control_attachment_id_example' # str | 
    update_export_control_attachment_request = openapi_client.UpdateExportControlAttachmentRequest() # UpdateExportControlAttachmentRequest | Export control attachment attributes

    try:
        api_response = api_instance.update_export_control_attachment(export_control_attachment_id, update_export_control_attachment_request)
        print("The response of ExportControlAttachmentsApi->update_export_control_attachment:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ExportControlAttachmentsApi->update_export_control_attachment: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **export_control_attachment_id** | **str**|  | 
 **update_export_control_attachment_request** | [**UpdateExportControlAttachmentRequest**](UpdateExportControlAttachmentRequest.md)| Export control attachment attributes | 

### Return type

[**CreateExportControlAttachment201Response**](CreateExportControlAttachment201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated export control attachment |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

