# openapi_client.ManufacturerModelsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**retrieve_manufacturer_modelinstance0**](ManufacturerModelsApi.md#retrieve_manufacturer_modelinstance0) | **GET** /manufacturer-models/{manufacturer_model_id} | 
[**retrieveacollectionof_manufacturer_modelobjects0**](ManufacturerModelsApi.md#retrieveacollectionof_manufacturer_modelobjects0) | **GET** /manufacturer-models | 


# **retrieve_manufacturer_modelinstance0**
> RetrieveManufacturerModelinstance0200Response retrieve_manufacturer_modelinstance0(manufacturer_model_id, include=include)

Retrieve a manufacturer model instance

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieve_manufacturer_modelinstance0200_response import RetrieveManufacturerModelinstance0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ManufacturerModelsApi(api_client)
    manufacturer_model_id = 'manufacturer_model_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_manufacturer_modelinstance0(manufacturer_model_id, include=include)
        print("The response of ManufacturerModelsApi->retrieve_manufacturer_modelinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ManufacturerModelsApi->retrieve_manufacturer_modelinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **manufacturer_model_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**RetrieveManufacturerModelinstance0200Response**](RetrieveManufacturerModelinstance0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | instance of a manufacturer model |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_manufacturer_modelobjects0**
> RetrieveacollectionofManufacturerModelobjects0200Response retrieveacollectionof_manufacturer_modelobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_manufacturer_name=filter_manufacturer_name, filter_model=filter_model, filter_external_system_name=filter_external_system_name, filter_external_system_url=filter_external_system_url, filter_created_at=filter_created_at, filter=filter)

Retrieve the list of manufacturer models

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_manufacturer_modelobjects0200_response import RetrieveacollectionofManufacturerModelobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.ManufacturerModelsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_manufacturer_name = 'filter_manufacturer_name_example' # str |  (optional)
    filter_model = 'filter_model_example' # str |  (optional)
    filter_external_system_name = 'filter_external_system_name_example' # str |  (optional)
    filter_external_system_url = 'filter_external_system_url_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.retrieveacollectionof_manufacturer_modelobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_manufacturer_name=filter_manufacturer_name, filter_model=filter_model, filter_external_system_name=filter_external_system_name, filter_external_system_url=filter_external_system_url, filter_created_at=filter_created_at, filter=filter)
        print("The response of ManufacturerModelsApi->retrieveacollectionof_manufacturer_modelobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ManufacturerModelsApi->retrieveacollectionof_manufacturer_modelobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_manufacturer_name** | **str**|  | [optional] 
 **filter_model** | **str**|  | [optional] 
 **filter_external_system_name** | **str**|  | [optional] 
 **filter_external_system_url** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**RetrieveacollectionofManufacturerModelobjects0200Response**](RetrieveacollectionofManufacturerModelobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of manufacturer models |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

