# openapi_client.PermissionGroupsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_permission_groups**](PermissionGroupsApi.md#get_permission_groups) | **GET** /permission-groups | 


# **get_permission_groups**
> GetPermissionGroups200Response get_permission_groups(skip_cache=skip_cache)

Retrieve the list of permission groups.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.get_permission_groups200_response import GetPermissionGroups200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PermissionGroupsApi(api_client)
    skip_cache = False # bool |  (optional) (default to False)

    try:
        api_response = api_instance.get_permission_groups(skip_cache=skip_cache)
        print("The response of PermissionGroupsApi->get_permission_groups:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PermissionGroupsApi->get_permission_groups: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **skip_cache** | **bool**|  | [optional] [default to False]

### Return type

[**GetPermissionGroups200Response**](GetPermissionGroups200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of permission groups. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

