# openapi_client.PidsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_pid**](PidsApi.md#create_pid) | **POST** /pids | 


# **create_pid**
> CreatePid201Response create_pid(create_pid_request=create_pid_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_pid201_response import CreatePid201Response
from openapi_client.models.create_pid_request import CreatePidRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PidsApi(api_client)
    create_pid_request = openapi_client.CreatePidRequest() # CreatePidRequest | Payload to ask the system to create a pid for a device, platform or configuration. (optional)

    try:
        api_response = api_instance.create_pid(create_pid_request=create_pid_request)
        print("The response of PidsApi->create_pid:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PidsApi->create_pid: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_pid_request** | [**CreatePidRequest**](CreatePidRequest.md)| Payload to ask the system to create a pid for a device, platform or configuration. | [optional] 

### Return type

[**CreatePid201Response**](CreatePid201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Result of the pid generation. |  -  |
**401** | Authentification required. |  -  |
**403** | 403 Error |  -  |
**404** |  |  -  |
**409** | Conflict on performing the operation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

