# openapi_client.PlatformAttachmentsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_platform_attachment0**](PlatformAttachmentsApi.md#create_platform_attachment0) | **POST** /platform-attachments | 
[**delete_platform_attachmentfromplatformattachment0**](PlatformAttachmentsApi.md#delete_platform_attachmentfromplatformattachment0) | **DELETE** /platform-attachments/{platform_attachment_id} | 
[**platform_attachments_platform_attachment_id_file_filename_get**](PlatformAttachmentsApi.md#platform_attachments_platform_attachment_id_file_filename_get) | **GET** /platform-attachments/{platform_attachment_id}/file/{filename} | 
[**retrieve_platform_attachmentinstance0**](PlatformAttachmentsApi.md#retrieve_platform_attachmentinstance0) | **GET** /platform-attachments/{platform_attachment_id} | 
[**retrieveacollectionof_platform_attachmentobjects0**](PlatformAttachmentsApi.md#retrieveacollectionof_platform_attachmentobjects0) | **GET** /platform-attachments | 
[**update_platform_attachment0**](PlatformAttachmentsApi.md#update_platform_attachment0) | **PATCH** /platform-attachments/{platform_attachment_id} | 


# **create_platform_attachment0**
> CreatePlatformAttachment0201Response create_platform_attachment0(create_platform_attachment0_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform_attachment0201_response import CreatePlatformAttachment0201Response
from openapi_client.models.create_platform_attachment0_request import CreatePlatformAttachment0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformAttachmentsApi(api_client)
    create_platform_attachment0_request = openapi_client.CreatePlatformAttachment0Request() # CreatePlatformAttachment0Request | PlatformAttachment attributes

    try:
        api_response = api_instance.create_platform_attachment0(create_platform_attachment0_request)
        print("The response of PlatformAttachmentsApi->create_platform_attachment0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformAttachmentsApi->create_platform_attachment0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_platform_attachment0_request** | [**CreatePlatformAttachment0Request**](CreatePlatformAttachment0Request.md)| PlatformAttachment attributes | 

### Return type

[**CreatePlatformAttachment0201Response**](CreatePlatformAttachment0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created platform attachment |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_platform_attachmentfromplatformattachment0**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_platform_attachmentfromplatformattachment0(platform_attachment_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformAttachmentsApi(api_client)
    platform_attachment_id = 'platform_attachment_id_example' # str | 

    try:
        api_response = api_instance.delete_platform_attachmentfromplatformattachment0(platform_attachment_id)
        print("The response of PlatformAttachmentsApi->delete_platform_attachmentfromplatformattachment0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformAttachmentsApi->delete_platform_attachmentfromplatformattachment0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_attachment_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**401** | Authentification required. |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_attachments_platform_attachment_id_file_filename_get**
> platform_attachments_platform_attachment_id_file_filename_get(platform_attachment_id, filename)

Endpoint to get the content of the uploaded file.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformAttachmentsApi(api_client)
    platform_attachment_id = 'platform_attachment_id_example' # str | 
    filename = 'file' # str | Filename of the file. Can be arbitrary, it will always return the same file - no matter how this parameter is set. Backend needs this to allow linking of filenames for uploads. (default to 'file')

    try:
        api_instance.platform_attachments_platform_attachment_id_file_filename_get(platform_attachment_id, filename)
    except Exception as e:
        print("Exception when calling PlatformAttachmentsApi->platform_attachments_platform_attachment_id_file_filename_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_attachment_id** | **str**|  | 
 **filename** | **str**| Filename of the file. Can be arbitrary, it will always return the same file - no matter how this parameter is set. Backend needs this to allow linking of filenames for uploads. | [default to &#39;file&#39;]

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Content of the file. Content-Type is the same as the original upload. |  -  |
**401** | Authentification required. |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_platform_attachmentinstance0**
> CreatePlatformAttachment0201Response retrieve_platform_attachmentinstance0(platform_attachment_id, include=include)

Retrieve PlatformAttachment from platform_attachment

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform_attachment0201_response import CreatePlatformAttachment0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformAttachmentsApi(api_client)
    platform_attachment_id = 'platform_attachment_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_platform_attachmentinstance0(platform_attachment_id, include=include)
        print("The response of PlatformAttachmentsApi->retrieve_platform_attachmentinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformAttachmentsApi->retrieve_platform_attachmentinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_attachment_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreatePlatformAttachment0201Response**](CreatePlatformAttachment0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a platform attachment |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_platform_attachmentobjects0**
> RetrieveacollectionofPlatformAttachmentobjects0200Response retrieveacollectionof_platform_attachmentobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_url=filter_url, filter_description=filter_description, filter_is_upload=filter_is_upload, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id, filter=filter)

Retrieve PlatformAttachment from platform_attachment

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_platform_attachmentobjects0200_response import RetrieveacollectionofPlatformAttachmentobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformAttachmentsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_url = 'filter_url_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_is_upload = True # bool |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_platform_id = 'filter_platform_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.retrieveacollectionof_platform_attachmentobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_url=filter_url, filter_description=filter_description, filter_is_upload=filter_is_upload, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id, filter=filter)
        print("The response of PlatformAttachmentsApi->retrieveacollectionof_platform_attachmentobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformAttachmentsApi->retrieveacollectionof_platform_attachmentobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_url** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_is_upload** | **bool**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_platform_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**RetrieveacollectionofPlatformAttachmentobjects0200Response**](RetrieveacollectionofPlatformAttachmentobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of platform attachments |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_platform_attachment0**
> CreatePlatformAttachment0201Response update_platform_attachment0(platform_attachment_id, update_platform_attachment0_request=update_platform_attachment0_request)

Update PlatformAttachment attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform_attachment0201_response import CreatePlatformAttachment0201Response
from openapi_client.models.update_platform_attachment0_request import UpdatePlatformAttachment0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformAttachmentsApi(api_client)
    platform_attachment_id = 'platform_attachment_id_example' # str | 
    update_platform_attachment0_request = openapi_client.UpdatePlatformAttachment0Request() # UpdatePlatformAttachment0Request | Payload to update a platform attachment (optional)

    try:
        api_response = api_instance.update_platform_attachment0(platform_attachment_id, update_platform_attachment0_request=update_platform_attachment0_request)
        print("The response of PlatformAttachmentsApi->update_platform_attachment0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformAttachmentsApi->update_platform_attachment0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_attachment_id** | **str**|  | 
 **update_platform_attachment0_request** | [**UpdatePlatformAttachment0Request**](UpdatePlatformAttachment0Request.md)| Payload to update a platform attachment | [optional] 

### Return type

[**CreatePlatformAttachment0201Response**](CreatePlatformAttachment0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Updated platform attachment |  -  |
**401** | Authentification required. |  -  |
**404** |  |  -  |
**409** | Conflict on performing the operation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

