# openapi_client.PlatformImagesApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_platform_image**](PlatformImagesApi.md#create_platform_image) | **POST** /platform-images | 
[**delete_platform_image**](PlatformImagesApi.md#delete_platform_image) | **DELETE** /platform-images/{platform_image_id} | 
[**retrieve_platform_image_instance**](PlatformImagesApi.md#retrieve_platform_image_instance) | **GET** /platform-images/{platform_image_id} | 
[**retrievecollectionof_platform_imageobjects**](PlatformImagesApi.md#retrievecollectionof_platform_imageobjects) | **GET** /platform-images | 
[**update_platform_image**](PlatformImagesApi.md#update_platform_image) | **PATCH** /platform-images/{platform_image_id} | 


# **create_platform_image**
> CreatePlatformImage201Response create_platform_image(create_platform_image_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform_image201_response import CreatePlatformImage201Response
from openapi_client.models.create_platform_image_request import CreatePlatformImageRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformImagesApi(api_client)
    create_platform_image_request = openapi_client.CreatePlatformImageRequest() # CreatePlatformImageRequest | 

    try:
        api_response = api_instance.create_platform_image(create_platform_image_request)
        print("The response of PlatformImagesApi->create_platform_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformImagesApi->create_platform_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_platform_image_request** | [**CreatePlatformImageRequest**](CreatePlatformImageRequest.md)|  | 

### Return type

[**CreatePlatformImage201Response**](CreatePlatformImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created platform image |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_platform_image**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_platform_image(platform_image_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformImagesApi(api_client)
    platform_image_id = 'platform_image_id_example' # str | 

    try:
        api_response = api_instance.delete_platform_image(platform_image_id)
        print("The response of PlatformImagesApi->delete_platform_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformImagesApi->delete_platform_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_image_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_platform_image_instance**
> CreatePlatformImage201Response retrieve_platform_image_instance(platform_image_id, include=include)

Retrieve a single platform image

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform_image201_response import CreatePlatformImage201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformImagesApi(api_client)
    platform_image_id = 'platform_image_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_platform_image_instance(platform_image_id, include=include)
        print("The response of PlatformImagesApi->retrieve_platform_image_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformImagesApi->retrieve_platform_image_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_image_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreatePlatformImage201Response**](CreatePlatformImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a platform image |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrievecollectionof_platform_imageobjects**
> RetrievecollectionofPlatformImageobjects200Response retrievecollectionof_platform_imageobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id, filter_attachment_id=filter_attachment_id)

Retrieve a list of platform images

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrievecollectionof_platform_imageobjects200_response import RetrievecollectionofPlatformImageobjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformImagesApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_order_index = 3.4 # float |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_platform_id = 'filter_platform_id_example' # str |  (optional)
    filter_attachment_id = 'filter_attachment_id_example' # str |  (optional)

    try:
        api_response = api_instance.retrievecollectionof_platform_imageobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id, filter_attachment_id=filter_attachment_id)
        print("The response of PlatformImagesApi->retrievecollectionof_platform_imageobjects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformImagesApi->retrievecollectionof_platform_imageobjects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_order_index** | **float**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_platform_id** | **str**|  | [optional] 
 **filter_attachment_id** | **str**|  | [optional] 

### Return type

[**RetrievecollectionofPlatformImageobjects200Response**](RetrievecollectionofPlatformImageobjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of platform images |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_platform_image**
> CreatePlatformImage201Response update_platform_image(platform_image_id, update_platform_image_request)

Update PlatformImage attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform_image201_response import CreatePlatformImage201Response
from openapi_client.models.update_platform_image_request import UpdatePlatformImageRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformImagesApi(api_client)
    platform_image_id = 'platform_image_id_example' # str | 
    update_platform_image_request = openapi_client.UpdatePlatformImageRequest() # UpdatePlatformImageRequest | PlatformImage attributes

    try:
        api_response = api_instance.update_platform_image(platform_image_id, update_platform_image_request)
        print("The response of PlatformImagesApi->update_platform_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformImagesApi->update_platform_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_image_id** | **str**|  | 
 **update_platform_image_request** | [**UpdatePlatformImageRequest**](UpdatePlatformImageRequest.md)| PlatformImage attributes | 

### Return type

[**CreatePlatformImage201Response**](CreatePlatformImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated platform image |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

