# openapi_client.PlatformMountActionsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**platform_mount_actions_get**](PlatformMountActionsApi.md#platform_mount_actions_get) | **GET** /platform-mount-actions | 
[**platform_mount_actions_platform_mount_action_id_delete**](PlatformMountActionsApi.md#platform_mount_actions_platform_mount_action_id_delete) | **DELETE** /platform-mount-actions/{platform_mount_action_id} | 
[**platform_mount_actions_platform_mount_action_id_get**](PlatformMountActionsApi.md#platform_mount_actions_platform_mount_action_id_get) | **GET** /platform-mount-actions/{platform_mount_action_id} | 
[**platform_mount_actions_platform_mount_action_id_patch**](PlatformMountActionsApi.md#platform_mount_actions_platform_mount_action_id_patch) | **PATCH** /platform-mount-actions/{platform_mount_action_id} | 
[**platform_mount_actions_post**](PlatformMountActionsApi.md#platform_mount_actions_post) | **POST** /platform-mount-actions | 


# **platform_mount_actions_get**
> PlatformMountActionsGet200Response platform_mount_actions_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_begin_date=filter_begin_date, filter_end_date=filter_end_date, filter_begin_description=filter_begin_description, filter_end_description=filter_end_description, filter_offset_x=filter_offset_x, filter_offset_y=filter_offset_y, filter_offset_z=filter_offset_z, filter_x=filter_x, filter_y=filter_y, filter_z=filter_z, filter_epsg_code=filter_epsg_code, filter_elevation_datum_name=filter_elevation_datum_name, filter_elevation_datum_uri=filter_elevation_datum_uri, filter_label=filter_label, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id, filter_parent_platform_id=filter_parent_platform_id, filter_configuration_id=filter_configuration_id, filter=filter)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_mount_actions_get200_response import PlatformMountActionsGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformMountActionsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_begin_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_end_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_begin_description = 'filter_begin_description_example' # str |  (optional)
    filter_end_description = 'filter_end_description_example' # str |  (optional)
    filter_offset_x = 3.4 # float |  (optional)
    filter_offset_y = 3.4 # float |  (optional)
    filter_offset_z = 3.4 # float |  (optional)
    filter_x = 3.4 # float |  (optional)
    filter_y = 3.4 # float |  (optional)
    filter_z = 3.4 # float |  (optional)
    filter_epsg_code = 'filter_epsg_code_example' # str |  (optional)
    filter_elevation_datum_name = 'filter_elevation_datum_name_example' # str |  (optional)
    filter_elevation_datum_uri = 'filter_elevation_datum_uri_example' # str |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_platform_id = 'filter_platform_id_example' # str |  (optional)
    filter_parent_platform_id = 'filter_parent_platform_id_example' # str |  (optional)
    filter_configuration_id = 'filter_configuration_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.platform_mount_actions_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_begin_date=filter_begin_date, filter_end_date=filter_end_date, filter_begin_description=filter_begin_description, filter_end_description=filter_end_description, filter_offset_x=filter_offset_x, filter_offset_y=filter_offset_y, filter_offset_z=filter_offset_z, filter_x=filter_x, filter_y=filter_y, filter_z=filter_z, filter_epsg_code=filter_epsg_code, filter_elevation_datum_name=filter_elevation_datum_name, filter_elevation_datum_uri=filter_elevation_datum_uri, filter_label=filter_label, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id, filter_parent_platform_id=filter_parent_platform_id, filter_configuration_id=filter_configuration_id, filter=filter)
        print("The response of PlatformMountActionsApi->platform_mount_actions_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformMountActionsApi->platform_mount_actions_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_begin_date** | **datetime**|  | [optional] 
 **filter_end_date** | **datetime**|  | [optional] 
 **filter_begin_description** | **str**|  | [optional] 
 **filter_end_description** | **str**|  | [optional] 
 **filter_offset_x** | **float**|  | [optional] 
 **filter_offset_y** | **float**|  | [optional] 
 **filter_offset_z** | **float**|  | [optional] 
 **filter_x** | **float**|  | [optional] 
 **filter_y** | **float**|  | [optional] 
 **filter_z** | **float**|  | [optional] 
 **filter_epsg_code** | **str**|  | [optional] 
 **filter_elevation_datum_name** | **str**|  | [optional] 
 **filter_elevation_datum_uri** | **str**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_platform_id** | **str**|  | [optional] 
 **filter_parent_platform_id** | **str**|  | [optional] 
 **filter_configuration_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**PlatformMountActionsGet200Response**](PlatformMountActionsGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of platform mounts |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_mount_actions_platform_mount_action_id_delete**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response platform_mount_actions_platform_mount_action_id_delete(platform_mount_action_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformMountActionsApi(api_client)
    platform_mount_action_id = 'platform_mount_action_id_example' # str | 

    try:
        api_response = api_instance.platform_mount_actions_platform_mount_action_id_delete(platform_mount_action_id)
        print("The response of PlatformMountActionsApi->platform_mount_actions_platform_mount_action_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformMountActionsApi->platform_mount_actions_platform_mount_action_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_mount_action_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_mount_actions_platform_mount_action_id_get**
> PlatformMountActionsPost201Response platform_mount_actions_platform_mount_action_id_get(platform_mount_action_id, include=include)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_mount_actions_post201_response import PlatformMountActionsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformMountActionsApi(api_client)
    platform_mount_action_id = 'platform_mount_action_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.platform_mount_actions_platform_mount_action_id_get(platform_mount_action_id, include=include)
        print("The response of PlatformMountActionsApi->platform_mount_actions_platform_mount_action_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformMountActionsApi->platform_mount_actions_platform_mount_action_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_mount_action_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**PlatformMountActionsPost201Response**](PlatformMountActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a platform mount |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_mount_actions_platform_mount_action_id_patch**
> PlatformMountActionsPost201Response platform_mount_actions_platform_mount_action_id_patch(platform_mount_action_id, platform_mount_actions_platform_mount_action_id_patch_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_mount_actions_platform_mount_action_id_patch_request import PlatformMountActionsPlatformMountActionIdPatchRequest
from openapi_client.models.platform_mount_actions_post201_response import PlatformMountActionsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformMountActionsApi(api_client)
    platform_mount_action_id = 'platform_mount_action_id_example' # str | 
    platform_mount_actions_platform_mount_action_id_patch_request = openapi_client.PlatformMountActionsPlatformMountActionIdPatchRequest() # PlatformMountActionsPlatformMountActionIdPatchRequest | PlatformMountAction attributes

    try:
        api_response = api_instance.platform_mount_actions_platform_mount_action_id_patch(platform_mount_action_id, platform_mount_actions_platform_mount_action_id_patch_request)
        print("The response of PlatformMountActionsApi->platform_mount_actions_platform_mount_action_id_patch:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformMountActionsApi->platform_mount_actions_platform_mount_action_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_mount_action_id** | **str**|  | 
 **platform_mount_actions_platform_mount_action_id_patch_request** | [**PlatformMountActionsPlatformMountActionIdPatchRequest**](PlatformMountActionsPlatformMountActionIdPatchRequest.md)| PlatformMountAction attributes | 

### Return type

[**PlatformMountActionsPost201Response**](PlatformMountActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated platform mount |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_mount_actions_post**
> PlatformMountActionsPost201Response platform_mount_actions_post(platform_mount_actions_post_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_mount_actions_post201_response import PlatformMountActionsPost201Response
from openapi_client.models.platform_mount_actions_post_request import PlatformMountActionsPostRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformMountActionsApi(api_client)
    platform_mount_actions_post_request = openapi_client.PlatformMountActionsPostRequest() # PlatformMountActionsPostRequest | 

    try:
        api_response = api_instance.platform_mount_actions_post(platform_mount_actions_post_request)
        print("The response of PlatformMountActionsApi->platform_mount_actions_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformMountActionsApi->platform_mount_actions_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_mount_actions_post_request** | [**PlatformMountActionsPostRequest**](PlatformMountActionsPostRequest.md)|  | 

### Return type

[**PlatformMountActionsPost201Response**](PlatformMountActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created platform mount |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

