# openapi_client.PlatformParametersApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_platform_parameter**](PlatformParametersApi.md#create_platform_parameter) | **POST** /platform-parameters | 
[**delete_platform_parameter**](PlatformParametersApi.md#delete_platform_parameter) | **DELETE** /platform-parameters/{platform_parameter_id} | 
[**retriececollectionof_platform_parameterobjects**](PlatformParametersApi.md#retriececollectionof_platform_parameterobjects) | **GET** /platform-parameters | 
[**retrieve_platform_parameterinstance**](PlatformParametersApi.md#retrieve_platform_parameterinstance) | **GET** /platform-parameters/{platform_parameter_id} | 
[**update_platform_parameter**](PlatformParametersApi.md#update_platform_parameter) | **PATCH** /platform-parameters/{platform_parameter_id} | 


# **create_platform_parameter**
> CreatePlatformParameter201Response create_platform_parameter(create_platform_parameter_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform_parameter201_response import CreatePlatformParameter201Response
from openapi_client.models.create_platform_parameter_request import CreatePlatformParameterRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformParametersApi(api_client)
    create_platform_parameter_request = openapi_client.CreatePlatformParameterRequest() # CreatePlatformParameterRequest | 

    try:
        api_response = api_instance.create_platform_parameter(create_platform_parameter_request)
        print("The response of PlatformParametersApi->create_platform_parameter:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformParametersApi->create_platform_parameter: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_platform_parameter_request** | [**CreatePlatformParameterRequest**](CreatePlatformParameterRequest.md)|  | 

### Return type

[**CreatePlatformParameter201Response**](CreatePlatformParameter201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created platform parameter |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_platform_parameter**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_platform_parameter(platform_parameter_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformParametersApi(api_client)
    platform_parameter_id = 'platform_parameter_id_example' # str | 

    try:
        api_response = api_instance.delete_platform_parameter(platform_parameter_id)
        print("The response of PlatformParametersApi->delete_platform_parameter:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformParametersApi->delete_platform_parameter: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_parameter_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retriececollectionof_platform_parameterobjects**
> RetriececollectionofPlatformParameterobjects200Response retriececollectionof_platform_parameterobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_description=filter_description, filter_unit_uri=filter_unit_uri, filter_unit_name=filter_unit_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id)

Retrieve the list of platform parameters

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retriececollectionof_platform_parameterobjects200_response import RetriececollectionofPlatformParameterobjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformParametersApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_unit_uri = 'filter_unit_uri_example' # str |  (optional)
    filter_unit_name = 'filter_unit_name_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_platform_id = 'filter_platform_id_example' # str |  (optional)

    try:
        api_response = api_instance.retriececollectionof_platform_parameterobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_description=filter_description, filter_unit_uri=filter_unit_uri, filter_unit_name=filter_unit_name, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id)
        print("The response of PlatformParametersApi->retriececollectionof_platform_parameterobjects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformParametersApi->retriececollectionof_platform_parameterobjects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_unit_uri** | **str**|  | [optional] 
 **filter_unit_name** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_platform_id** | **str**|  | [optional] 

### Return type

[**RetriececollectionofPlatformParameterobjects200Response**](RetriececollectionofPlatformParameterobjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of platform parameters |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_platform_parameterinstance**
> CreatePlatformParameter201Response retrieve_platform_parameterinstance(platform_parameter_id, include=include)

Retrieve a single platform parameter

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform_parameter201_response import CreatePlatformParameter201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformParametersApi(api_client)
    platform_parameter_id = 'platform_parameter_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_platform_parameterinstance(platform_parameter_id, include=include)
        print("The response of PlatformParametersApi->retrieve_platform_parameterinstance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformParametersApi->retrieve_platform_parameterinstance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_parameter_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreatePlatformParameter201Response**](CreatePlatformParameter201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a platform parameter |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_platform_parameter**
> CreatePlatformParameter201Response update_platform_parameter(platform_parameter_id, update_platform_parameter_request)

Update PlatformParameter attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform_parameter201_response import CreatePlatformParameter201Response
from openapi_client.models.update_platform_parameter_request import UpdatePlatformParameterRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformParametersApi(api_client)
    platform_parameter_id = 'platform_parameter_id_example' # str | 
    update_platform_parameter_request = openapi_client.UpdatePlatformParameterRequest() # UpdatePlatformParameterRequest | PlatformParameter attributes

    try:
        api_response = api_instance.update_platform_parameter(platform_parameter_id, update_platform_parameter_request)
        print("The response of PlatformParametersApi->update_platform_parameter:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformParametersApi->update_platform_parameter: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_parameter_id** | **str**|  | 
 **update_platform_parameter_request** | [**UpdatePlatformParameterRequest**](UpdatePlatformParameterRequest.md)| PlatformParameter attributes | 

### Return type

[**CreatePlatformParameter201Response**](CreatePlatformParameter201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated platform parameter |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

