# openapi_client.PlatformSoftwareUpdateActionsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**platform_software_update_actions_get**](PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_get) | **GET** /platform-software-update-actions | 
[**platform_software_update_actions_platform_software_update_action_id_delete**](PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_platform_software_update_action_id_delete) | **DELETE** /platform-software-update-actions/{platform_software_update_action_id} | 
[**platform_software_update_actions_platform_software_update_action_id_get**](PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_platform_software_update_action_id_get) | **GET** /platform-software-update-actions/{platform_software_update_action_id} | 
[**platform_software_update_actions_platform_software_update_action_id_patch**](PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_platform_software_update_action_id_patch) | **PATCH** /platform-software-update-actions/{platform_software_update_action_id} | 
[**platform_software_update_actions_post**](PlatformSoftwareUpdateActionsApi.md#platform_software_update_actions_post) | **POST** /platform-software-update-actions | 


# **platform_software_update_actions_get**
> PlatformSoftwareUpdateActionsGet200Response platform_software_update_actions_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_software_type_name=filter_software_type_name, filter_software_type_uri=filter_software_type_uri, filter_version=filter_version, filter_repository_url=filter_repository_url, filter_description=filter_description, filter_update_date=filter_update_date, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id, filter=filter)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_software_update_actions_get200_response import PlatformSoftwareUpdateActionsGet200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformSoftwareUpdateActionsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_software_type_name = 'filter_software_type_name_example' # str |  (optional)
    filter_software_type_uri = 'filter_software_type_uri_example' # str |  (optional)
    filter_version = 'filter_version_example' # str |  (optional)
    filter_repository_url = 'filter_repository_url_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_update_date = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_platform_id = 'filter_platform_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.platform_software_update_actions_get(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_software_type_name=filter_software_type_name, filter_software_type_uri=filter_software_type_uri, filter_version=filter_version, filter_repository_url=filter_repository_url, filter_description=filter_description, filter_update_date=filter_update_date, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_platform_id=filter_platform_id, filter=filter)
        print("The response of PlatformSoftwareUpdateActionsApi->platform_software_update_actions_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformSoftwareUpdateActionsApi->platform_software_update_actions_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_software_type_name** | **str**|  | [optional] 
 **filter_software_type_uri** | **str**|  | [optional] 
 **filter_version** | **str**|  | [optional] 
 **filter_repository_url** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_update_date** | **datetime**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_platform_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**PlatformSoftwareUpdateActionsGet200Response**](PlatformSoftwareUpdateActionsGet200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of platform software update actions |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_software_update_actions_platform_software_update_action_id_delete**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response platform_software_update_actions_platform_software_update_action_id_delete(platform_software_update_action_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformSoftwareUpdateActionsApi(api_client)
    platform_software_update_action_id = 'platform_software_update_action_id_example' # str | 

    try:
        api_response = api_instance.platform_software_update_actions_platform_software_update_action_id_delete(platform_software_update_action_id)
        print("The response of PlatformSoftwareUpdateActionsApi->platform_software_update_actions_platform_software_update_action_id_delete:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformSoftwareUpdateActionsApi->platform_software_update_actions_platform_software_update_action_id_delete: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_software_update_action_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_software_update_actions_platform_software_update_action_id_get**
> PlatformSoftwareUpdateActionsPost201Response platform_software_update_actions_platform_software_update_action_id_get(platform_software_update_action_id, include=include)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_software_update_actions_post201_response import PlatformSoftwareUpdateActionsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformSoftwareUpdateActionsApi(api_client)
    platform_software_update_action_id = 'platform_software_update_action_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.platform_software_update_actions_platform_software_update_action_id_get(platform_software_update_action_id, include=include)
        print("The response of PlatformSoftwareUpdateActionsApi->platform_software_update_actions_platform_software_update_action_id_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformSoftwareUpdateActionsApi->platform_software_update_actions_platform_software_update_action_id_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_software_update_action_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**PlatformSoftwareUpdateActionsPost201Response**](PlatformSoftwareUpdateActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a platform software update action |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_software_update_actions_platform_software_update_action_id_patch**
> PlatformSoftwareUpdateActionsPost201Response platform_software_update_actions_platform_software_update_action_id_patch(platform_software_update_action_id, platform_software_update_actions_platform_software_update_action_id_patch_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_software_update_actions_platform_software_update_action_id_patch_request import PlatformSoftwareUpdateActionsPlatformSoftwareUpdateActionIdPatchRequest
from openapi_client.models.platform_software_update_actions_post201_response import PlatformSoftwareUpdateActionsPost201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformSoftwareUpdateActionsApi(api_client)
    platform_software_update_action_id = 'platform_software_update_action_id_example' # str | 
    platform_software_update_actions_platform_software_update_action_id_patch_request = openapi_client.PlatformSoftwareUpdateActionsPlatformSoftwareUpdateActionIdPatchRequest() # PlatformSoftwareUpdateActionsPlatformSoftwareUpdateActionIdPatchRequest | Platform software update action attributes

    try:
        api_response = api_instance.platform_software_update_actions_platform_software_update_action_id_patch(platform_software_update_action_id, platform_software_update_actions_platform_software_update_action_id_patch_request)
        print("The response of PlatformSoftwareUpdateActionsApi->platform_software_update_actions_platform_software_update_action_id_patch:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformSoftwareUpdateActionsApi->platform_software_update_actions_platform_software_update_action_id_patch: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_software_update_action_id** | **str**|  | 
 **platform_software_update_actions_platform_software_update_action_id_patch_request** | [**PlatformSoftwareUpdateActionsPlatformSoftwareUpdateActionIdPatchRequest**](PlatformSoftwareUpdateActionsPlatformSoftwareUpdateActionIdPatchRequest.md)| Platform software update action attributes | 

### Return type

[**PlatformSoftwareUpdateActionsPost201Response**](PlatformSoftwareUpdateActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated platform software update action |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **platform_software_update_actions_post**
> PlatformSoftwareUpdateActionsPost201Response platform_software_update_actions_post(platform_software_update_actions_post_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.platform_software_update_actions_post201_response import PlatformSoftwareUpdateActionsPost201Response
from openapi_client.models.platform_software_update_actions_post_request import PlatformSoftwareUpdateActionsPostRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformSoftwareUpdateActionsApi(api_client)
    platform_software_update_actions_post_request = openapi_client.PlatformSoftwareUpdateActionsPostRequest() # PlatformSoftwareUpdateActionsPostRequest | 

    try:
        api_response = api_instance.platform_software_update_actions_post(platform_software_update_actions_post_request)
        print("The response of PlatformSoftwareUpdateActionsApi->platform_software_update_actions_post:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformSoftwareUpdateActionsApi->platform_software_update_actions_post: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_software_update_actions_post_request** | [**PlatformSoftwareUpdateActionsPostRequest**](PlatformSoftwareUpdateActionsPostRequest.md)|  | 

### Return type

[**PlatformSoftwareUpdateActionsPost201Response**](PlatformSoftwareUpdateActionsPost201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created platform software update action |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

