# openapi_client.PlatformsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**archive_platform**](PlatformsApi.md#archive_platform) | **POST** /platforms/{platform_id}/archive | 
[**create_platform0**](PlatformsApi.md#create_platform0) | **POST** /platforms | 
[**delete_platformfromplatform3**](PlatformsApi.md#delete_platformfromplatform3) | **DELETE** /platforms/{platform_id} | 
[**restore_platform**](PlatformsApi.md#restore_platform) | **POST** /platforms/{platform_id}/restore | 
[**retrieve_platform_sensor_ml**](PlatformsApi.md#retrieve_platform_sensor_ml) | **GET** /platforms/{platform_id}/sensorml | 
[**retrieve_platforminstance0**](PlatformsApi.md#retrieve_platforminstance0) | **GET** /platforms/{platform_id} | 
[**retrieveacollectionof_platformobjects0**](PlatformsApi.md#retrieveacollectionof_platformobjects0) | **GET** /platforms | 
[**update_platform0**](PlatformsApi.md#update_platform0) | **PATCH** /platforms/{platform_id} | 


# **archive_platform**
> archive_platform(platform_id)

Archive a platform.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformsApi(api_client)
    platform_id = 'platform_id_example' # str | 

    try:
        api_instance.archive_platform(platform_id)
    except Exception as e:
        print("Exception when calling PlatformsApi->archive_platform: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Platform was archived succesfully. |  -  |
**401** | Authentification required. |  -  |
**403** | 403 Error |  -  |
**404** |  |  -  |
**409** | Conflict on performing the operation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_platform0**
> CreatePlatform0201Response create_platform0(create_platform0_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform0201_response import CreatePlatform0201Response
from openapi_client.models.create_platform0_request import CreatePlatform0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformsApi(api_client)
    create_platform0_request = openapi_client.CreatePlatform0Request() # CreatePlatform0Request | 

    try:
        api_response = api_instance.create_platform0(create_platform0_request)
        print("The response of PlatformsApi->create_platform0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformsApi->create_platform0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_platform0_request** | [**CreatePlatform0Request**](CreatePlatform0Request.md)|  | 

### Return type

[**CreatePlatform0201Response**](CreatePlatform0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created platform |  -  |
**401** | Authentification required. |  -  |
**409** | Conflict on performing the operation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_platformfromplatform3**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_platformfromplatform3(platform_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformsApi(api_client)
    platform_id = 'platform_id_example' # str | 

    try:
        api_response = api_instance.delete_platformfromplatform3(platform_id)
        print("The response of PlatformsApi->delete_platformfromplatform3:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformsApi->delete_platformfromplatform3: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**401** | Authentification required. |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **restore_platform**
> restore_platform(platform_id)

Restore an archived platform.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformsApi(api_client)
    platform_id = 'platform_id_example' # str | 

    try:
        api_instance.restore_platform(platform_id)
    except Exception as e:
        print("Exception when calling PlatformsApi->restore_platform: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Restoring of the platform was succesful. |  -  |
**401** | Authentification required. |  -  |
**403** | 403 Error |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_platform_sensor_ml**
> retrieve_platform_sensor_ml(platform_id)

Retrieve Platform sensorML

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformsApi(api_client)
    platform_id = 'platform_id_example' # str | 

    try:
        api_instance.retrieve_platform_sensor_ml(platform_id)
    except Exception as e:
        print("Exception when calling PlatformsApi->retrieve_platform_sensor_ml: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/xml, application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | SensorML response for the platform |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_platforminstance0**
> CreatePlatform0201Response retrieve_platforminstance0(platform_id, include=include)

Retrieve Platform from platform

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform0201_response import CreatePlatform0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformsApi(api_client)
    platform_id = 'platform_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_platforminstance0(platform_id, include=include)
        print("The response of PlatformsApi->retrieve_platforminstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformsApi->retrieve_platforminstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreatePlatform0201Response**](CreatePlatform0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a platform |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_platformobjects0**
> RetrieveacollectionofPlatformobjects0200Response retrieveacollectionof_platformobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_description=filter_description, filter_short_name=filter_short_name, filter_long_name=filter_long_name, filter_manufacturer_uri=filter_manufacturer_uri, filter_manufacturer_name=filter_manufacturer_name, filter_model=filter_model, filter_platform_type_uri=filter_platform_type_uri, filter_platform_type_name=filter_platform_type_name, filter_status_uri=filter_status_uri, filter_status_name=filter_status_name, filter_website=filter_website, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_is_private=filter_is_private, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_update_description=filter_update_description, filter_country=filter_country, filter_inventory_number=filter_inventory_number, filter_serial_number=filter_serial_number, filter_persistent_identifier=filter_persistent_identifier, filter_schema_version=filter_schema_version, filter_identifier_type=filter_identifier_type, filter=filter, hide_archived=hide_archived)

Retrieve Platform

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_platformobjects0200_response import RetrieveacollectionofPlatformobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_short_name = 'filter_short_name_example' # str |  (optional)
    filter_long_name = 'filter_long_name_example' # str |  (optional)
    filter_manufacturer_uri = 'filter_manufacturer_uri_example' # str |  (optional)
    filter_manufacturer_name = 'filter_manufacturer_name_example' # str |  (optional)
    filter_model = 'filter_model_example' # str |  (optional)
    filter_platform_type_uri = 'filter_platform_type_uri_example' # str |  (optional)
    filter_platform_type_name = 'filter_platform_type_name_example' # str |  (optional)
    filter_status_uri = 'filter_status_uri_example' # str |  (optional)
    filter_status_name = 'filter_status_name_example' # str |  (optional)
    filter_website = 'filter_website_example' # str |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_is_private = True # bool |  (optional)
    filter_is_internal = True # bool |  (optional)
    filter_is_public = True # bool |  (optional)
    filter_archived = True # bool |  (optional)
    filter_update_description = 'filter_update_description_example' # str |  (optional)
    filter_country = 'filter_country_example' # str |  (optional)
    filter_inventory_number = 'filter_inventory_number_example' # str |  (optional)
    filter_serial_number = 'filter_serial_number_example' # str |  (optional)
    filter_persistent_identifier = 'filter_persistent_identifier_example' # str |  (optional)
    filter_schema_version = 'filter_schema_version_example' # str |  (optional)
    filter_identifier_type = 'filter_identifier_type_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)
    hide_archived = True # bool | In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. (optional) (default to True)

    try:
        api_response = api_instance.retrieveacollectionof_platformobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_description=filter_description, filter_short_name=filter_short_name, filter_long_name=filter_long_name, filter_manufacturer_uri=filter_manufacturer_uri, filter_manufacturer_name=filter_manufacturer_name, filter_model=filter_model, filter_platform_type_uri=filter_platform_type_uri, filter_platform_type_name=filter_platform_type_name, filter_status_uri=filter_status_uri, filter_status_name=filter_status_name, filter_website=filter_website, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_is_private=filter_is_private, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_update_description=filter_update_description, filter_country=filter_country, filter_inventory_number=filter_inventory_number, filter_serial_number=filter_serial_number, filter_persistent_identifier=filter_persistent_identifier, filter_schema_version=filter_schema_version, filter_identifier_type=filter_identifier_type, filter=filter, hide_archived=hide_archived)
        print("The response of PlatformsApi->retrieveacollectionof_platformobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformsApi->retrieveacollectionof_platformobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_short_name** | **str**|  | [optional] 
 **filter_long_name** | **str**|  | [optional] 
 **filter_manufacturer_uri** | **str**|  | [optional] 
 **filter_manufacturer_name** | **str**|  | [optional] 
 **filter_model** | **str**|  | [optional] 
 **filter_platform_type_uri** | **str**|  | [optional] 
 **filter_platform_type_name** | **str**|  | [optional] 
 **filter_status_uri** | **str**|  | [optional] 
 **filter_status_name** | **str**|  | [optional] 
 **filter_website** | **str**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_is_private** | **bool**|  | [optional] 
 **filter_is_internal** | **bool**|  | [optional] 
 **filter_is_public** | **bool**|  | [optional] 
 **filter_archived** | **bool**|  | [optional] 
 **filter_update_description** | **str**|  | [optional] 
 **filter_country** | **str**|  | [optional] 
 **filter_inventory_number** | **str**|  | [optional] 
 **filter_serial_number** | **str**|  | [optional] 
 **filter_persistent_identifier** | **str**|  | [optional] 
 **filter_schema_version** | **str**|  | [optional] 
 **filter_identifier_type** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 
 **hide_archived** | **bool**| In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. | [optional] [default to True]

### Return type

[**RetrieveacollectionofPlatformobjects0200Response**](RetrieveacollectionofPlatformobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of platforms |  -  |
**400** | Invalid filter parameter. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_platform0**
> CreatePlatform0201Response update_platform0(platform_id, update_platform0_request)

Update Platform attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_platform0201_response import CreatePlatform0201Response
from openapi_client.models.update_platform0_request import UpdatePlatform0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.PlatformsApi(api_client)
    platform_id = 'platform_id_example' # str | 
    update_platform0_request = openapi_client.UpdatePlatform0Request() # UpdatePlatform0Request | Platform attributes

    try:
        api_response = api_instance.update_platform0(platform_id, update_platform0_request)
        print("The response of PlatformsApi->update_platform0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PlatformsApi->update_platform0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **platform_id** | **str**|  | 
 **update_platform0_request** | [**UpdatePlatform0Request**](UpdatePlatform0Request.md)| Platform attributes | 

### Return type

[**CreatePlatform0201Response**](CreatePlatform0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated platform |  -  |
**401** | Authentification required. |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

