# openapi_client.SiteAttachmentsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_site_attachment0**](SiteAttachmentsApi.md#create_site_attachment0) | **POST** /site-attachments | 
[**delete_site_attachmentfromsiteattachment0**](SiteAttachmentsApi.md#delete_site_attachmentfromsiteattachment0) | **DELETE** /site-attachments/{site_attachment_id} | 
[**retrieve_site_attachmentinstance0**](SiteAttachmentsApi.md#retrieve_site_attachmentinstance0) | **GET** /site-attachments/{site_attachment_id} | 
[**retrieveacollectionof_site_attachmentobjects0**](SiteAttachmentsApi.md#retrieveacollectionof_site_attachmentobjects0) | **GET** /site-attachments | 
[**site_attachments_site_attachment_id_file_filename_get**](SiteAttachmentsApi.md#site_attachments_site_attachment_id_file_filename_get) | **GET** /site-attachments/{site_attachment_id}/file/{filename} | 
[**update_site_attachment0**](SiteAttachmentsApi.md#update_site_attachment0) | **PATCH** /site-attachments/{site_attachment_id} | 


# **create_site_attachment0**
> CreateSiteAttachment0201Response create_site_attachment0(create_site_attachment0_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_site_attachment0201_response import CreateSiteAttachment0201Response
from openapi_client.models.create_site_attachment0_request import CreateSiteAttachment0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteAttachmentsApi(api_client)
    create_site_attachment0_request = openapi_client.CreateSiteAttachment0Request() # CreateSiteAttachment0Request | 

    try:
        api_response = api_instance.create_site_attachment0(create_site_attachment0_request)
        print("The response of SiteAttachmentsApi->create_site_attachment0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteAttachmentsApi->create_site_attachment0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_site_attachment0_request** | [**CreateSiteAttachment0Request**](CreateSiteAttachment0Request.md)|  | 

### Return type

[**CreateSiteAttachment0201Response**](CreateSiteAttachment0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created site attachment |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_site_attachmentfromsiteattachment0**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_site_attachmentfromsiteattachment0(site_attachment_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteAttachmentsApi(api_client)
    site_attachment_id = 'site_attachment_id_example' # str | 

    try:
        api_response = api_instance.delete_site_attachmentfromsiteattachment0(site_attachment_id)
        print("The response of SiteAttachmentsApi->delete_site_attachmentfromsiteattachment0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteAttachmentsApi->delete_site_attachmentfromsiteattachment0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_attachment_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_site_attachmentinstance0**
> CreateSiteAttachment0201Response retrieve_site_attachmentinstance0(site_attachment_id, include=include)

Retrieve SiteAttachment from site_attachment

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_site_attachment0201_response import CreateSiteAttachment0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteAttachmentsApi(api_client)
    site_attachment_id = 'site_attachment_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_site_attachmentinstance0(site_attachment_id, include=include)
        print("The response of SiteAttachmentsApi->retrieve_site_attachmentinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteAttachmentsApi->retrieve_site_attachmentinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_attachment_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateSiteAttachment0201Response**](CreateSiteAttachment0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a site attachment |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_site_attachmentobjects0**
> RetrieveacollectionofSiteAttachmentobjects0200Response retrieveacollectionof_site_attachmentobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_url=filter_url, filter_description=filter_description, filter_is_upload=filter_is_upload, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_site_id=filter_site_id, filter=filter)

Retrieve SiteAttachment from site_attachment

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_site_attachmentobjects0200_response import RetrieveacollectionofSiteAttachmentobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteAttachmentsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_url = 'filter_url_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_is_upload = True # bool |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_site_id = 'filter_site_id_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.retrieveacollectionof_site_attachmentobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_label=filter_label, filter_url=filter_url, filter_description=filter_description, filter_is_upload=filter_is_upload, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_site_id=filter_site_id, filter=filter)
        print("The response of SiteAttachmentsApi->retrieveacollectionof_site_attachmentobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteAttachmentsApi->retrieveacollectionof_site_attachmentobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_url** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_is_upload** | **bool**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_site_id** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**RetrieveacollectionofSiteAttachmentobjects0200Response**](RetrieveacollectionofSiteAttachmentobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of site attachments |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **site_attachments_site_attachment_id_file_filename_get**
> site_attachments_site_attachment_id_file_filename_get(site_attachment_id, filename)

Endpoint to get the content of the uploaded file.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteAttachmentsApi(api_client)
    site_attachment_id = 'site_attachment_id_example' # str | 
    filename = 'file' # str | Filename of the file. Can be arbitrary, it will always return the same file - no matter how this parameter is set. Backend needs this to allow linking of filenames for uploads. (default to 'file')

    try:
        api_instance.site_attachments_site_attachment_id_file_filename_get(site_attachment_id, filename)
    except Exception as e:
        print("Exception when calling SiteAttachmentsApi->site_attachments_site_attachment_id_file_filename_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_attachment_id** | **str**|  | 
 **filename** | **str**| Filename of the file. Can be arbitrary, it will always return the same file - no matter how this parameter is set. Backend needs this to allow linking of filenames for uploads. | [default to &#39;file&#39;]

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Content of the file. Content-Type is the same as the original upload. |  -  |
**401** | Authentification required. |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_site_attachment0**
> CreateSiteAttachment0201Response update_site_attachment0(site_attachment_id, update_site_attachment0_request)

Update SiteAttachment attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_site_attachment0201_response import CreateSiteAttachment0201Response
from openapi_client.models.update_site_attachment0_request import UpdateSiteAttachment0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteAttachmentsApi(api_client)
    site_attachment_id = 'site_attachment_id_example' # str | 
    update_site_attachment0_request = openapi_client.UpdateSiteAttachment0Request() # UpdateSiteAttachment0Request | SiteAttachment attributes

    try:
        api_response = api_instance.update_site_attachment0(site_attachment_id, update_site_attachment0_request)
        print("The response of SiteAttachmentsApi->update_site_attachment0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteAttachmentsApi->update_site_attachment0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_attachment_id** | **str**|  | 
 **update_site_attachment0_request** | [**UpdateSiteAttachment0Request**](UpdateSiteAttachment0Request.md)| SiteAttachment attributes | 

### Return type

[**CreateSiteAttachment0201Response**](CreateSiteAttachment0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated site attachment |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

