# openapi_client.SiteImagesApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_site_image**](SiteImagesApi.md#create_site_image) | **POST** /site-images | 
[**delete_site_image**](SiteImagesApi.md#delete_site_image) | **DELETE** /site-images/{site_image_id} | 
[**retrieve_site_image_instance**](SiteImagesApi.md#retrieve_site_image_instance) | **GET** /site-images/{site_image_id} | 
[**retrievecollectionof_site_imageobjects**](SiteImagesApi.md#retrievecollectionof_site_imageobjects) | **GET** /site-images | 
[**update_site_image**](SiteImagesApi.md#update_site_image) | **PATCH** /site-images/{site_image_id} | 


# **create_site_image**
> CreateSiteImage201Response create_site_image(create_site_image_request)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_site_image201_response import CreateSiteImage201Response
from openapi_client.models.create_site_image_request import CreateSiteImageRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteImagesApi(api_client)
    create_site_image_request = openapi_client.CreateSiteImageRequest() # CreateSiteImageRequest | 

    try:
        api_response = api_instance.create_site_image(create_site_image_request)
        print("The response of SiteImagesApi->create_site_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteImagesApi->create_site_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_site_image_request** | [**CreateSiteImageRequest**](CreateSiteImageRequest.md)|  | 

### Return type

[**CreateSiteImage201Response**](CreateSiteImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created site image |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_site_image**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_site_image(site_image_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteImagesApi(api_client)
    site_image_id = 'site_image_id_example' # str | 

    try:
        api_response = api_instance.delete_site_image(site_image_id)
        print("The response of SiteImagesApi->delete_site_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteImagesApi->delete_site_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_image_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_site_image_instance**
> CreateSiteImage201Response retrieve_site_image_instance(site_image_id, include=include)

Retrieve a single site image

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_site_image201_response import CreateSiteImage201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteImagesApi(api_client)
    site_image_id = 'site_image_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_site_image_instance(site_image_id, include=include)
        print("The response of SiteImagesApi->retrieve_site_image_instance:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteImagesApi->retrieve_site_image_instance: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_image_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateSiteImage201Response**](CreateSiteImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a site image |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrievecollectionof_site_imageobjects**
> RetrievecollectionofSiteImageobjects200Response retrievecollectionof_site_imageobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_site_id=filter_site_id, filter_attachment_id=filter_attachment_id)

Retrieve a list of site images

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrievecollectionof_site_imageobjects200_response import RetrievecollectionofSiteImageobjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteImagesApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_order_index = 3.4 # float |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_site_id = 'filter_site_id_example' # str |  (optional)
    filter_attachment_id = 'filter_attachment_id_example' # str |  (optional)

    try:
        api_response = api_instance.retrievecollectionof_site_imageobjects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_order_index=filter_order_index, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_site_id=filter_site_id, filter_attachment_id=filter_attachment_id)
        print("The response of SiteImagesApi->retrievecollectionof_site_imageobjects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteImagesApi->retrievecollectionof_site_imageobjects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_order_index** | **float**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_site_id** | **str**|  | [optional] 
 **filter_attachment_id** | **str**|  | [optional] 

### Return type

[**RetrievecollectionofSiteImageobjects200Response**](RetrievecollectionofSiteImageobjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of site images |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_site_image**
> CreateSiteImage201Response update_site_image(site_image_id, update_site_image_request)

Update SiteImage attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_site_image201_response import CreateSiteImage201Response
from openapi_client.models.update_site_image_request import UpdateSiteImageRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SiteImagesApi(api_client)
    site_image_id = 'site_image_id_example' # str | 
    update_site_image_request = openapi_client.UpdateSiteImageRequest() # UpdateSiteImageRequest | SiteImage attributes

    try:
        api_response = api_instance.update_site_image(site_image_id, update_site_image_request)
        print("The response of SiteImagesApi->update_site_image:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SiteImagesApi->update_site_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_image_id** | **str**|  | 
 **update_site_image_request** | [**UpdateSiteImageRequest**](UpdateSiteImageRequest.md)| SiteImage attributes | 

### Return type

[**CreateSiteImage201Response**](CreateSiteImage201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated site image |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

