# openapi_client.SitesApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**archive_site**](SitesApi.md#archive_site) | **POST** /sites/{site_id}/archive | 
[**create_site0**](SitesApi.md#create_site0) | **POST** /sites | 
[**delete_sitefromsite0**](SitesApi.md#delete_sitefromsite0) | **DELETE** /sites/{site_id} | 
[**restore_site**](SitesApi.md#restore_site) | **POST** /sites/{site_id}/restore | 
[**retrieve_site_sensor_ml**](SitesApi.md#retrieve_site_sensor_ml) | **GET** /sites/{site_id}/sensorml | 
[**retrieve_siteinstance0**](SitesApi.md#retrieve_siteinstance0) | **GET** /sites/{site_id} | 
[**retrieveacollectionof_siteobjects0**](SitesApi.md#retrieveacollectionof_siteobjects0) | **GET** /sites | 
[**update_site0**](SitesApi.md#update_site0) | **PATCH** /sites/{site_id} | 


# **archive_site**
> archive_site(site_id)

Archive a site.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SitesApi(api_client)
    site_id = 'site_id_example' # str | 

    try:
        api_instance.archive_site(site_id)
    except Exception as e:
        print("Exception when calling SitesApi->archive_site: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Site was archived succesfully. |  -  |
**401** | Authentification required. |  -  |
**403** | 403 Error |  -  |
**404** |  |  -  |
**409** | Conflict on performing the operation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_site0**
> CreateSite0201Response create_site0(create_site0_request)

create a Site

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_site0201_response import CreateSite0201Response
from openapi_client.models.create_site0_request import CreateSite0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SitesApi(api_client)
    create_site0_request = openapi_client.CreateSite0Request() # CreateSite0Request | 

    try:
        api_response = api_instance.create_site0(create_site0_request)
        print("The response of SitesApi->create_site0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SitesApi->create_site0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_site0_request** | [**CreateSite0Request**](CreateSite0Request.md)|  | 

### Return type

[**CreateSite0201Response**](CreateSite0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Payload of the created site |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_sitefromsite0**
> DeleteConfigurationAttachmentfromconfigurationattachment0200Response delete_sitefromsite0(site_id)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SitesApi(api_client)
    site_id = 'site_id_example' # str | 

    try:
        api_response = api_instance.delete_sitefromsite0(site_id)
        print("The response of SitesApi->delete_sitefromsite0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SitesApi->delete_sitefromsite0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **str**|  | 

### Return type

[**DeleteConfigurationAttachmentfromconfigurationattachment0200Response**](DeleteConfigurationAttachmentfromconfigurationattachment0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete an Object |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **restore_site**
> restore_site(site_id)

Restore an archived site.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SitesApi(api_client)
    site_id = 'site_id_example' # str | 

    try:
        api_instance.restore_site(site_id)
    except Exception as e:
        print("Exception when calling SitesApi->restore_site: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Restoring of the site was succesful. |  -  |
**401** | Authentification required. |  -  |
**403** | 403 Error |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_site_sensor_ml**
> retrieve_site_sensor_ml(site_id)

Retrieve Site sensorML

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SitesApi(api_client)
    site_id = 'site_id_example' # str | 

    try:
        api_instance.retrieve_site_sensor_ml(site_id)
    except Exception as e:
        print("Exception when calling SitesApi->retrieve_site_sensor_ml: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/xml, application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | SensorML response for the site |  -  |
**401** | Authentification required. |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieve_siteinstance0**
> CreateSite0201Response retrieve_siteinstance0(site_id, include=include)

Retrieve Site from site

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_site0201_response import CreateSite0201Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SitesApi(api_client)
    site_id = 'site_id_example' # str | 
    include = '' # str | Relationships to include. (optional) (default to '')

    try:
        api_response = api_instance.retrieve_siteinstance0(site_id, include=include)
        print("The response of SitesApi->retrieve_siteinstance0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SitesApi->retrieve_siteinstance0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **str**|  | 
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]

### Return type

[**CreateSite0201Response**](CreateSite0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a site |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveacollectionof_siteobjects0**
> RetrieveacollectionofSiteobjects0200Response retrieveacollectionof_siteobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_persistent_identifier=filter_persistent_identifier, filter_label=filter_label, filter_description=filter_description, filter_epsg_code=filter_epsg_code, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_update_description=filter_update_description, filter_street=filter_street, filter_street_number=filter_street_number, filter_city=filter_city, filter_zip_code=filter_zip_code, filter_country=filter_country, filter_building=filter_building, filter_room=filter_room, filter_site_type_uri=filter_site_type_uri, filter_site_type_name=filter_site_type_name, filter_site_usage_uri=filter_site_usage_uri, filter_site_usage_name=filter_site_usage_name, filter_elevation=filter_elevation, filter_elevation_datum_name=filter_elevation_datum_name, filter_elevation_datum_uri=filter_elevation_datum_uri, filter_website=filter_website, filter=filter, hide_archived=hide_archived)

Retrieve Site from site

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_siteobjects0200_response import RetrieveacollectionofSiteobjects0200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SitesApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_persistent_identifier = 'filter_persistent_identifier_example' # str |  (optional)
    filter_label = 'filter_label_example' # str |  (optional)
    filter_description = 'filter_description_example' # str |  (optional)
    filter_epsg_code = 'filter_epsg_code_example' # str |  (optional)
    filter_is_internal = True # bool |  (optional)
    filter_is_public = True # bool |  (optional)
    filter_archived = True # bool |  (optional)
    filter_created_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_updated_at = '2013-10-20T19:20:30+01:00' # datetime |  (optional)
    filter_update_description = 'filter_update_description_example' # str |  (optional)
    filter_street = 'filter_street_example' # str |  (optional)
    filter_street_number = 'filter_street_number_example' # str |  (optional)
    filter_city = 'filter_city_example' # str |  (optional)
    filter_zip_code = 'filter_zip_code_example' # str |  (optional)
    filter_country = 'filter_country_example' # str |  (optional)
    filter_building = 'filter_building_example' # str |  (optional)
    filter_room = 'filter_room_example' # str |  (optional)
    filter_site_type_uri = 'filter_site_type_uri_example' # str |  (optional)
    filter_site_type_name = 'filter_site_type_name_example' # str |  (optional)
    filter_site_usage_uri = 'filter_site_usage_uri_example' # str |  (optional)
    filter_site_usage_name = 'filter_site_usage_name_example' # str |  (optional)
    filter_elevation = 3.4 # float |  (optional)
    filter_elevation_datum_name = 'filter_elevation_datum_name_example' # str |  (optional)
    filter_elevation_datum_uri = 'filter_elevation_datum_uri_example' # str |  (optional)
    filter_website = 'filter_website_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)
    hide_archived = True # bool | In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. (optional) (default to True)

    try:
        api_response = api_instance.retrieveacollectionof_siteobjects0(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_persistent_identifier=filter_persistent_identifier, filter_label=filter_label, filter_description=filter_description, filter_epsg_code=filter_epsg_code, filter_is_internal=filter_is_internal, filter_is_public=filter_is_public, filter_archived=filter_archived, filter_created_at=filter_created_at, filter_updated_at=filter_updated_at, filter_update_description=filter_update_description, filter_street=filter_street, filter_street_number=filter_street_number, filter_city=filter_city, filter_zip_code=filter_zip_code, filter_country=filter_country, filter_building=filter_building, filter_room=filter_room, filter_site_type_uri=filter_site_type_uri, filter_site_type_name=filter_site_type_name, filter_site_usage_uri=filter_site_usage_uri, filter_site_usage_name=filter_site_usage_name, filter_elevation=filter_elevation, filter_elevation_datum_name=filter_elevation_datum_name, filter_elevation_datum_uri=filter_elevation_datum_uri, filter_website=filter_website, filter=filter, hide_archived=hide_archived)
        print("The response of SitesApi->retrieveacollectionof_siteobjects0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SitesApi->retrieveacollectionof_siteobjects0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_persistent_identifier** | **str**|  | [optional] 
 **filter_label** | **str**|  | [optional] 
 **filter_description** | **str**|  | [optional] 
 **filter_epsg_code** | **str**|  | [optional] 
 **filter_is_internal** | **bool**|  | [optional] 
 **filter_is_public** | **bool**|  | [optional] 
 **filter_archived** | **bool**|  | [optional] 
 **filter_created_at** | **datetime**|  | [optional] 
 **filter_updated_at** | **datetime**|  | [optional] 
 **filter_update_description** | **str**|  | [optional] 
 **filter_street** | **str**|  | [optional] 
 **filter_street_number** | **str**|  | [optional] 
 **filter_city** | **str**|  | [optional] 
 **filter_zip_code** | **str**|  | [optional] 
 **filter_country** | **str**|  | [optional] 
 **filter_building** | **str**|  | [optional] 
 **filter_room** | **str**|  | [optional] 
 **filter_site_type_uri** | **str**|  | [optional] 
 **filter_site_type_name** | **str**|  | [optional] 
 **filter_site_usage_uri** | **str**|  | [optional] 
 **filter_site_usage_name** | **str**|  | [optional] 
 **filter_elevation** | **float**|  | [optional] 
 **filter_elevation_datum_name** | **str**|  | [optional] 
 **filter_elevation_datum_uri** | **str**|  | [optional] 
 **filter_website** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 
 **hide_archived** | **bool**| In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones. | [optional] [default to True]

### Return type

[**RetrieveacollectionofSiteobjects0200Response**](RetrieveacollectionofSiteobjects0200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of sites |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_site0**
> CreateSite0201Response update_site0(site_id, update_site0_request)

Update Site attributes

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.create_site0201_response import CreateSite0201Response
from openapi_client.models.update_site0_request import UpdateSite0Request
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SitesApi(api_client)
    site_id = 'site_id_example' # str | 
    update_site0_request = openapi_client.UpdateSite0Request() # UpdateSite0Request | Site attributes

    try:
        api_response = api_instance.update_site0(site_id, update_site0_request)
        print("The response of SitesApi->update_site0:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SitesApi->update_site0: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **site_id** | **str**|  | 
 **update_site0_request** | [**UpdateSite0Request**](UpdateSite0Request.md)| Site attributes | 

### Return type

[**CreateSite0201Response**](CreateSite0201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/vnd.api+json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payload of the updated site |  -  |
**404** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

