# openapi_client.TsmEndpointsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**retrieveacollectionof_tsm_endpoint_objects**](TsmEndpointsApi.md#retrieveacollectionof_tsm_endpoint_objects) | **GET** /tsm-endpoints | 
[**retrieveinstanceof_tsm_endpoint_object**](TsmEndpointsApi.md#retrieveinstanceof_tsm_endpoint_object) | **GET** /tsm-endpoints/{tsm_endpoint_id} | 


# **retrieveacollectionof_tsm_endpoint_objects**
> RetrieveacollectionofTsmEndpointObjects200Response retrieveacollectionof_tsm_endpoint_objects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_name=filter_name, filter_url=filter_url, filter=filter)

Retrieve a collection of tsm endpoint objects

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveacollectionof_tsm_endpoint_objects200_response import RetrieveacollectionofTsmEndpointObjects200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.TsmEndpointsApi(api_client)
    include = '' # str | Relationships to include. (optional) (default to '')
    page_number = 1 # int | Page number to query (optional) (default to 1)
    page_size = 30 # int | Max number of items (optional) (default to 30)
    sort = '' # str | Sort order (optional) (default to '')
    filter_id = 'filter_id_example' # str |  (optional)
    filter_name = 'filter_name_example' # str |  (optional)
    filter_url = 'filter_url_example' # str |  (optional)
    filter = 'filter_example' # str | Custom filter (optional)

    try:
        api_response = api_instance.retrieveacollectionof_tsm_endpoint_objects(include=include, page_number=page_number, page_size=page_size, sort=sort, filter_id=filter_id, filter_name=filter_name, filter_url=filter_url, filter=filter)
        print("The response of TsmEndpointsApi->retrieveacollectionof_tsm_endpoint_objects:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TsmEndpointsApi->retrieveacollectionof_tsm_endpoint_objects: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **include** | **str**| Relationships to include. | [optional] [default to &#39;&#39;]
 **page_number** | **int**| Page number to query | [optional] [default to 1]
 **page_size** | **int**| Max number of items | [optional] [default to 30]
 **sort** | **str**| Sort order | [optional] [default to &#39;&#39;]
 **filter_id** | **str**|  | [optional] 
 **filter_name** | **str**|  | [optional] 
 **filter_url** | **str**|  | [optional] 
 **filter** | **str**| Custom filter | [optional] 

### Return type

[**RetrieveacollectionofTsmEndpointObjects200Response**](RetrieveacollectionofTsmEndpointObjects200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of TSM endpoints |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **retrieveinstanceof_tsm_endpoint_object**
> RetrieveinstanceofTsmEndpointObject200Response retrieveinstanceof_tsm_endpoint_object(tsm_endpoint_id)

Retrieve a single Tsm endpoint object

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.retrieveinstanceof_tsm_endpoint_object200_response import RetrieveinstanceofTsmEndpointObject200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.TsmEndpointsApi(api_client)
    tsm_endpoint_id = 'tsm_endpoint_id_example' # str | 

    try:
        api_response = api_instance.retrieveinstanceof_tsm_endpoint_object(tsm_endpoint_id)
        print("The response of TsmEndpointsApi->retrieveinstanceof_tsm_endpoint_object:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TsmEndpointsApi->retrieveinstanceof_tsm_endpoint_object: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tsm_endpoint_id** | **str**|  | 

### Return type

[**RetrieveinstanceofTsmEndpointObject200Response**](RetrieveinstanceofTsmEndpointObject200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Instance of a TSM endpoint |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

