# openapi_client.UsageStatisticsApi

All URIs are relative to *http://localhost/rdm/svm-api/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_usage_statistics**](UsageStatisticsApi.md#get_usage_statistics) | **GET** /usage-statistics | 


# **get_usage_statistics**
> GetUsageStatistics200Response get_usage_statistics(extended=extended)

User info about the current usage of the sms instance.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import openapi_client
from openapi_client.models.get_usage_statistics200_response import GetUsageStatistics200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/rdm/svm-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "http://localhost/rdm/svm-api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.UsageStatisticsApi(api_client)
    extended = False # bool | Show some more information (pids, uploads, organizations, ...) (optional) (default to False)

    try:
        api_response = api_instance.get_usage_statistics(extended=extended)
        print("The response of UsageStatisticsApi->get_usage_statistics:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UsageStatisticsApi->get_usage_statistics: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extended** | **bool**| Show some more information (pids, uploads, organizations, ...) | [optional] [default to False]

### Return type

[**GetUsageStatistics200Response**](GetUsageStatistics200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Usage statistic informations |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

