# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from openapi_client.models.create_configuration0201_response import CreateConfiguration0201Response
from openapi_client.models.create_configuration0_request import CreateConfiguration0Request
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.models.retrieveacollectionof_configurationobjects0200_response import RetrieveacollectionofConfigurationobjects0200Response
from openapi_client.models.update_configuration0_request import UpdateConfiguration0Request

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType


class ConfigurationsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def archive_configuration(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """archive_configuration

        Archive a configuration.

        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._archive_configuration_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
            '409': "Conflict",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def archive_configuration_with_http_info(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """archive_configuration

        Archive a configuration.

        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._archive_configuration_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
            '409': "Conflict",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def archive_configuration_without_preload_content(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """archive_configuration

        Archive a configuration.

        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._archive_configuration_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
            '409': "Conflict",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _archive_configuration_serialize(
        self,
        configuration_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/configurations/{configuration_id}/archive',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_configuration0(
        self,
        create_configuration0_request: CreateConfiguration0Request,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateConfiguration0201Response:
        """create_configuration0

        create a Configuration

        :param create_configuration0_request: (required)
        :type create_configuration0_request: CreateConfiguration0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_configuration0_serialize(
            create_configuration0_request=create_configuration0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateConfiguration0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_configuration0_with_http_info(
        self,
        create_configuration0_request: CreateConfiguration0Request,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateConfiguration0201Response]:
        """create_configuration0

        create a Configuration

        :param create_configuration0_request: (required)
        :type create_configuration0_request: CreateConfiguration0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_configuration0_serialize(
            create_configuration0_request=create_configuration0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateConfiguration0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_configuration0_without_preload_content(
        self,
        create_configuration0_request: CreateConfiguration0Request,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create_configuration0

        create a Configuration

        :param create_configuration0_request: (required)
        :type create_configuration0_request: CreateConfiguration0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_configuration0_serialize(
            create_configuration0_request=create_configuration0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateConfiguration0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_configuration0_serialize(
        self,
        create_configuration0_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_configuration0_request is not None:
            _body_params = create_configuration0_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/configurations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_configurationfromconfiguration0(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteConfigurationAttachmentfromconfigurationattachment0200Response:
        """delete_configurationfromconfiguration0


        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_configurationfromconfiguration0_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_configurationfromconfiguration0_with_http_info(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteConfigurationAttachmentfromconfigurationattachment0200Response]:
        """delete_configurationfromconfiguration0


        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_configurationfromconfiguration0_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_configurationfromconfiguration0_without_preload_content(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete_configurationfromconfiguration0


        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_configurationfromconfiguration0_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_configurationfromconfiguration0_serialize(
        self,
        configuration_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/configurations/{configuration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def restore_configuration(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """restore_configuration

        Restore an archived configuration.

        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._restore_configuration_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def restore_configuration_with_http_info(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """restore_configuration

        Restore an archived configuration.

        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._restore_configuration_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def restore_configuration_without_preload_content(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """restore_configuration

        Restore an archived configuration.

        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._restore_configuration_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _restore_configuration_serialize(
        self,
        configuration_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/configurations/{configuration_id}/restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieve_configuration_sensor_ml(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """retrieve_configuration_sensor_ml

        Retrieve Configuration sensorML

        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_configuration_sensor_ml_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "AuthentificationRequired",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieve_configuration_sensor_ml_with_http_info(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """retrieve_configuration_sensor_ml

        Retrieve Configuration sensorML

        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_configuration_sensor_ml_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "AuthentificationRequired",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieve_configuration_sensor_ml_without_preload_content(
        self,
        configuration_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieve_configuration_sensor_ml

        Retrieve Configuration sensorML

        :param configuration_id: (required)
        :type configuration_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_configuration_sensor_ml_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "AuthentificationRequired",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieve_configuration_sensor_ml_serialize(
        self,
        configuration_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/configurations/{configuration_id}/sensorml',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieve_configurationinstance0(
        self,
        configuration_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateConfiguration0201Response:
        """retrieve_configurationinstance0

        Retrieve Configuration from configuration

        :param configuration_id: (required)
        :type configuration_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_configurationinstance0_serialize(
            configuration_id=configuration_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateConfiguration0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieve_configurationinstance0_with_http_info(
        self,
        configuration_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateConfiguration0201Response]:
        """retrieve_configurationinstance0

        Retrieve Configuration from configuration

        :param configuration_id: (required)
        :type configuration_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_configurationinstance0_serialize(
            configuration_id=configuration_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateConfiguration0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieve_configurationinstance0_without_preload_content(
        self,
        configuration_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieve_configurationinstance0

        Retrieve Configuration from configuration

        :param configuration_id: (required)
        :type configuration_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_configurationinstance0_serialize(
            configuration_id=configuration_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateConfiguration0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieve_configurationinstance0_serialize(
        self,
        configuration_id,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api.json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/configurations/{configuration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieveacollectionof_configurationobjects0(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_start_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_label: Optional[StrictStr] = None,
        filter_project: Optional[StrictStr] = None,
        filter_campaign: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_status: Optional[StrictStr] = None,
        filter_cfg_permission_group: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_is_internal: Optional[StrictBool] = None,
        filter_is_public: Optional[StrictBool] = None,
        filter_archived: Optional[StrictBool] = None,
        filter_update_description: Optional[StrictStr] = None,
        filter_persistent_identifier: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        hide_archived: Annotated[Optional[StrictBool], Field(description="In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RetrieveacollectionofConfigurationobjects0200Response:
        """retrieveacollectionof_configurationobjects0

        Retrieve Configuration from configuration

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_start_date:
        :type filter_start_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_label:
        :type filter_label: str
        :param filter_project:
        :type filter_project: str
        :param filter_campaign:
        :type filter_campaign: str
        :param filter_description:
        :type filter_description: str
        :param filter_status:
        :type filter_status: str
        :param filter_cfg_permission_group:
        :type filter_cfg_permission_group: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_is_internal:
        :type filter_is_internal: bool
        :param filter_is_public:
        :type filter_is_public: bool
        :param filter_archived:
        :type filter_archived: bool
        :param filter_update_description:
        :type filter_update_description: str
        :param filter_persistent_identifier:
        :type filter_persistent_identifier: str
        :param filter: Custom filter
        :type filter: str
        :param hide_archived: In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.
        :type hide_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_configurationobjects0_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_start_date=filter_start_date,
            filter_end_date=filter_end_date,
            filter_label=filter_label,
            filter_project=filter_project,
            filter_campaign=filter_campaign,
            filter_description=filter_description,
            filter_status=filter_status,
            filter_cfg_permission_group=filter_cfg_permission_group,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_is_internal=filter_is_internal,
            filter_is_public=filter_is_public,
            filter_archived=filter_archived,
            filter_update_description=filter_update_description,
            filter_persistent_identifier=filter_persistent_identifier,
            filter=filter,
            hide_archived=hide_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofConfigurationobjects0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieveacollectionof_configurationobjects0_with_http_info(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_start_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_label: Optional[StrictStr] = None,
        filter_project: Optional[StrictStr] = None,
        filter_campaign: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_status: Optional[StrictStr] = None,
        filter_cfg_permission_group: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_is_internal: Optional[StrictBool] = None,
        filter_is_public: Optional[StrictBool] = None,
        filter_archived: Optional[StrictBool] = None,
        filter_update_description: Optional[StrictStr] = None,
        filter_persistent_identifier: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        hide_archived: Annotated[Optional[StrictBool], Field(description="In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RetrieveacollectionofConfigurationobjects0200Response]:
        """retrieveacollectionof_configurationobjects0

        Retrieve Configuration from configuration

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_start_date:
        :type filter_start_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_label:
        :type filter_label: str
        :param filter_project:
        :type filter_project: str
        :param filter_campaign:
        :type filter_campaign: str
        :param filter_description:
        :type filter_description: str
        :param filter_status:
        :type filter_status: str
        :param filter_cfg_permission_group:
        :type filter_cfg_permission_group: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_is_internal:
        :type filter_is_internal: bool
        :param filter_is_public:
        :type filter_is_public: bool
        :param filter_archived:
        :type filter_archived: bool
        :param filter_update_description:
        :type filter_update_description: str
        :param filter_persistent_identifier:
        :type filter_persistent_identifier: str
        :param filter: Custom filter
        :type filter: str
        :param hide_archived: In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.
        :type hide_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_configurationobjects0_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_start_date=filter_start_date,
            filter_end_date=filter_end_date,
            filter_label=filter_label,
            filter_project=filter_project,
            filter_campaign=filter_campaign,
            filter_description=filter_description,
            filter_status=filter_status,
            filter_cfg_permission_group=filter_cfg_permission_group,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_is_internal=filter_is_internal,
            filter_is_public=filter_is_public,
            filter_archived=filter_archived,
            filter_update_description=filter_update_description,
            filter_persistent_identifier=filter_persistent_identifier,
            filter=filter,
            hide_archived=hide_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofConfigurationobjects0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieveacollectionof_configurationobjects0_without_preload_content(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_start_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_label: Optional[StrictStr] = None,
        filter_project: Optional[StrictStr] = None,
        filter_campaign: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_status: Optional[StrictStr] = None,
        filter_cfg_permission_group: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_is_internal: Optional[StrictBool] = None,
        filter_is_public: Optional[StrictBool] = None,
        filter_archived: Optional[StrictBool] = None,
        filter_update_description: Optional[StrictStr] = None,
        filter_persistent_identifier: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        hide_archived: Annotated[Optional[StrictBool], Field(description="In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieveacollectionof_configurationobjects0

        Retrieve Configuration from configuration

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_start_date:
        :type filter_start_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_label:
        :type filter_label: str
        :param filter_project:
        :type filter_project: str
        :param filter_campaign:
        :type filter_campaign: str
        :param filter_description:
        :type filter_description: str
        :param filter_status:
        :type filter_status: str
        :param filter_cfg_permission_group:
        :type filter_cfg_permission_group: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_is_internal:
        :type filter_is_internal: bool
        :param filter_is_public:
        :type filter_is_public: bool
        :param filter_archived:
        :type filter_archived: bool
        :param filter_update_description:
        :type filter_update_description: str
        :param filter_persistent_identifier:
        :type filter_persistent_identifier: str
        :param filter: Custom filter
        :type filter: str
        :param hide_archived: In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.
        :type hide_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_configurationobjects0_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_start_date=filter_start_date,
            filter_end_date=filter_end_date,
            filter_label=filter_label,
            filter_project=filter_project,
            filter_campaign=filter_campaign,
            filter_description=filter_description,
            filter_status=filter_status,
            filter_cfg_permission_group=filter_cfg_permission_group,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_is_internal=filter_is_internal,
            filter_is_public=filter_is_public,
            filter_archived=filter_archived,
            filter_update_description=filter_update_description,
            filter_persistent_identifier=filter_persistent_identifier,
            filter=filter,
            hide_archived=hide_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofConfigurationobjects0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieveacollectionof_configurationobjects0_serialize(
        self,
        include,
        page_number,
        page_size,
        sort,
        filter_id,
        filter_start_date,
        filter_end_date,
        filter_label,
        filter_project,
        filter_campaign,
        filter_description,
        filter_status,
        filter_cfg_permission_group,
        filter_created_at,
        filter_updated_at,
        filter_is_internal,
        filter_is_public,
        filter_archived,
        filter_update_description,
        filter_persistent_identifier,
        filter,
        hide_archived,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        if page_number is not None:
            
            _query_params.append(('page[number]', page_number))
            
        if page_size is not None:
            
            _query_params.append(('page[size]', page_size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if filter_id is not None:
            
            _query_params.append(('filter[id]', filter_id))
            
        if filter_start_date is not None:
            if isinstance(filter_start_date, datetime):
                _query_params.append(
                    (
                        'filter[start_date]',
                        filter_start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[start_date]', filter_start_date))
            
        if filter_end_date is not None:
            if isinstance(filter_end_date, datetime):
                _query_params.append(
                    (
                        'filter[end_date]',
                        filter_end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[end_date]', filter_end_date))
            
        if filter_label is not None:
            
            _query_params.append(('filter[label]', filter_label))
            
        if filter_project is not None:
            
            _query_params.append(('filter[project]', filter_project))
            
        if filter_campaign is not None:
            
            _query_params.append(('filter[campaign]', filter_campaign))
            
        if filter_description is not None:
            
            _query_params.append(('filter[description]', filter_description))
            
        if filter_status is not None:
            
            _query_params.append(('filter[status]', filter_status))
            
        if filter_cfg_permission_group is not None:
            
            _query_params.append(('filter[cfg_permission_group]', filter_cfg_permission_group))
            
        if filter_created_at is not None:
            if isinstance(filter_created_at, datetime):
                _query_params.append(
                    (
                        'filter[created_at]',
                        filter_created_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[created_at]', filter_created_at))
            
        if filter_updated_at is not None:
            if isinstance(filter_updated_at, datetime):
                _query_params.append(
                    (
                        'filter[updated_at]',
                        filter_updated_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[updated_at]', filter_updated_at))
            
        if filter_is_internal is not None:
            
            _query_params.append(('filter[is_internal]', filter_is_internal))
            
        if filter_is_public is not None:
            
            _query_params.append(('filter[is_public]', filter_is_public))
            
        if filter_archived is not None:
            
            _query_params.append(('filter[archived]', filter_archived))
            
        if filter_update_description is not None:
            
            _query_params.append(('filter[update_description]', filter_update_description))
            
        if filter_persistent_identifier is not None:
            
            _query_params.append(('filter[persistent_identifier]', filter_persistent_identifier))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if hide_archived is not None:
            
            _query_params.append(('hide_archived', hide_archived))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/configurations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieveacollectionof_site0(
        self,
        site_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_start_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_label: Optional[StrictStr] = None,
        filter_project: Optional[StrictStr] = None,
        filter_campaign: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_status: Optional[StrictStr] = None,
        filter_cfg_permission_group: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_is_internal: Optional[StrictBool] = None,
        filter_is_public: Optional[StrictBool] = None,
        filter_archived: Optional[StrictBool] = None,
        filter_update_description: Optional[StrictStr] = None,
        filter_persistent_identifier: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        hide_archived: Annotated[Optional[StrictBool], Field(description="In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RetrieveacollectionofConfigurationobjects0200Response:
        """retrieveacollectionof_site0

        Retrieve the configurations for a specific site.

        :param site_id: (required)
        :type site_id: str
        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_start_date:
        :type filter_start_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_label:
        :type filter_label: str
        :param filter_project:
        :type filter_project: str
        :param filter_campaign:
        :type filter_campaign: str
        :param filter_description:
        :type filter_description: str
        :param filter_status:
        :type filter_status: str
        :param filter_cfg_permission_group:
        :type filter_cfg_permission_group: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_is_internal:
        :type filter_is_internal: bool
        :param filter_is_public:
        :type filter_is_public: bool
        :param filter_archived:
        :type filter_archived: bool
        :param filter_update_description:
        :type filter_update_description: str
        :param filter_persistent_identifier:
        :type filter_persistent_identifier: str
        :param filter: Custom filter
        :type filter: str
        :param hide_archived: In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.
        :type hide_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_site0_serialize(
            site_id=site_id,
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_start_date=filter_start_date,
            filter_end_date=filter_end_date,
            filter_label=filter_label,
            filter_project=filter_project,
            filter_campaign=filter_campaign,
            filter_description=filter_description,
            filter_status=filter_status,
            filter_cfg_permission_group=filter_cfg_permission_group,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_is_internal=filter_is_internal,
            filter_is_public=filter_is_public,
            filter_archived=filter_archived,
            filter_update_description=filter_update_description,
            filter_persistent_identifier=filter_persistent_identifier,
            filter=filter,
            hide_archived=hide_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofConfigurationobjects0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieveacollectionof_site0_with_http_info(
        self,
        site_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_start_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_label: Optional[StrictStr] = None,
        filter_project: Optional[StrictStr] = None,
        filter_campaign: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_status: Optional[StrictStr] = None,
        filter_cfg_permission_group: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_is_internal: Optional[StrictBool] = None,
        filter_is_public: Optional[StrictBool] = None,
        filter_archived: Optional[StrictBool] = None,
        filter_update_description: Optional[StrictStr] = None,
        filter_persistent_identifier: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        hide_archived: Annotated[Optional[StrictBool], Field(description="In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RetrieveacollectionofConfigurationobjects0200Response]:
        """retrieveacollectionof_site0

        Retrieve the configurations for a specific site.

        :param site_id: (required)
        :type site_id: str
        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_start_date:
        :type filter_start_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_label:
        :type filter_label: str
        :param filter_project:
        :type filter_project: str
        :param filter_campaign:
        :type filter_campaign: str
        :param filter_description:
        :type filter_description: str
        :param filter_status:
        :type filter_status: str
        :param filter_cfg_permission_group:
        :type filter_cfg_permission_group: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_is_internal:
        :type filter_is_internal: bool
        :param filter_is_public:
        :type filter_is_public: bool
        :param filter_archived:
        :type filter_archived: bool
        :param filter_update_description:
        :type filter_update_description: str
        :param filter_persistent_identifier:
        :type filter_persistent_identifier: str
        :param filter: Custom filter
        :type filter: str
        :param hide_archived: In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.
        :type hide_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_site0_serialize(
            site_id=site_id,
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_start_date=filter_start_date,
            filter_end_date=filter_end_date,
            filter_label=filter_label,
            filter_project=filter_project,
            filter_campaign=filter_campaign,
            filter_description=filter_description,
            filter_status=filter_status,
            filter_cfg_permission_group=filter_cfg_permission_group,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_is_internal=filter_is_internal,
            filter_is_public=filter_is_public,
            filter_archived=filter_archived,
            filter_update_description=filter_update_description,
            filter_persistent_identifier=filter_persistent_identifier,
            filter=filter,
            hide_archived=hide_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofConfigurationobjects0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieveacollectionof_site0_without_preload_content(
        self,
        site_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_start_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_label: Optional[StrictStr] = None,
        filter_project: Optional[StrictStr] = None,
        filter_campaign: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_status: Optional[StrictStr] = None,
        filter_cfg_permission_group: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_is_internal: Optional[StrictBool] = None,
        filter_is_public: Optional[StrictBool] = None,
        filter_archived: Optional[StrictBool] = None,
        filter_update_description: Optional[StrictStr] = None,
        filter_persistent_identifier: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        hide_archived: Annotated[Optional[StrictBool], Field(description="In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieveacollectionof_site0

        Retrieve the configurations for a specific site.

        :param site_id: (required)
        :type site_id: str
        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_start_date:
        :type filter_start_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_label:
        :type filter_label: str
        :param filter_project:
        :type filter_project: str
        :param filter_campaign:
        :type filter_campaign: str
        :param filter_description:
        :type filter_description: str
        :param filter_status:
        :type filter_status: str
        :param filter_cfg_permission_group:
        :type filter_cfg_permission_group: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_is_internal:
        :type filter_is_internal: bool
        :param filter_is_public:
        :type filter_is_public: bool
        :param filter_archived:
        :type filter_archived: bool
        :param filter_update_description:
        :type filter_update_description: str
        :param filter_persistent_identifier:
        :type filter_persistent_identifier: str
        :param filter: Custom filter
        :type filter: str
        :param hide_archived: In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.
        :type hide_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_site0_serialize(
            site_id=site_id,
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_start_date=filter_start_date,
            filter_end_date=filter_end_date,
            filter_label=filter_label,
            filter_project=filter_project,
            filter_campaign=filter_campaign,
            filter_description=filter_description,
            filter_status=filter_status,
            filter_cfg_permission_group=filter_cfg_permission_group,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_is_internal=filter_is_internal,
            filter_is_public=filter_is_public,
            filter_archived=filter_archived,
            filter_update_description=filter_update_description,
            filter_persistent_identifier=filter_persistent_identifier,
            filter=filter,
            hide_archived=hide_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofConfigurationobjects0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieveacollectionof_site0_serialize(
        self,
        site_id,
        include,
        page_number,
        page_size,
        sort,
        filter_id,
        filter_start_date,
        filter_end_date,
        filter_label,
        filter_project,
        filter_campaign,
        filter_description,
        filter_status,
        filter_cfg_permission_group,
        filter_created_at,
        filter_updated_at,
        filter_is_internal,
        filter_is_public,
        filter_archived,
        filter_update_description,
        filter_persistent_identifier,
        filter,
        hide_archived,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if site_id is not None:
            _path_params['site_id'] = site_id
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        if page_number is not None:
            
            _query_params.append(('page[number]', page_number))
            
        if page_size is not None:
            
            _query_params.append(('page[size]', page_size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if filter_id is not None:
            
            _query_params.append(('filter[id]', filter_id))
            
        if filter_start_date is not None:
            if isinstance(filter_start_date, datetime):
                _query_params.append(
                    (
                        'filter[start_date]',
                        filter_start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[start_date]', filter_start_date))
            
        if filter_end_date is not None:
            if isinstance(filter_end_date, datetime):
                _query_params.append(
                    (
                        'filter[end_date]',
                        filter_end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[end_date]', filter_end_date))
            
        if filter_label is not None:
            
            _query_params.append(('filter[label]', filter_label))
            
        if filter_project is not None:
            
            _query_params.append(('filter[project]', filter_project))
            
        if filter_campaign is not None:
            
            _query_params.append(('filter[campaign]', filter_campaign))
            
        if filter_description is not None:
            
            _query_params.append(('filter[description]', filter_description))
            
        if filter_status is not None:
            
            _query_params.append(('filter[status]', filter_status))
            
        if filter_cfg_permission_group is not None:
            
            _query_params.append(('filter[cfg_permission_group]', filter_cfg_permission_group))
            
        if filter_created_at is not None:
            if isinstance(filter_created_at, datetime):
                _query_params.append(
                    (
                        'filter[created_at]',
                        filter_created_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[created_at]', filter_created_at))
            
        if filter_updated_at is not None:
            if isinstance(filter_updated_at, datetime):
                _query_params.append(
                    (
                        'filter[updated_at]',
                        filter_updated_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[updated_at]', filter_updated_at))
            
        if filter_is_internal is not None:
            
            _query_params.append(('filter[is_internal]', filter_is_internal))
            
        if filter_is_public is not None:
            
            _query_params.append(('filter[is_public]', filter_is_public))
            
        if filter_archived is not None:
            
            _query_params.append(('filter[archived]', filter_archived))
            
        if filter_update_description is not None:
            
            _query_params.append(('filter[update_description]', filter_update_description))
            
        if filter_persistent_identifier is not None:
            
            _query_params.append(('filter[persistent_identifier]', filter_persistent_identifier))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if hide_archived is not None:
            
            _query_params.append(('hide_archived', hide_archived))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/sites/{site_id}/configurations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_configuration0(
        self,
        configuration_id: StrictStr,
        update_configuration0_request: Annotated[UpdateConfiguration0Request, Field(description="Configuration attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateConfiguration0201Response:
        """update_configuration0

        Update Configuration attributes

        :param configuration_id: (required)
        :type configuration_id: str
        :param update_configuration0_request: Configuration attributes (required)
        :type update_configuration0_request: UpdateConfiguration0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_configuration0_serialize(
            configuration_id=configuration_id,
            update_configuration0_request=update_configuration0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateConfiguration0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_configuration0_with_http_info(
        self,
        configuration_id: StrictStr,
        update_configuration0_request: Annotated[UpdateConfiguration0Request, Field(description="Configuration attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateConfiguration0201Response]:
        """update_configuration0

        Update Configuration attributes

        :param configuration_id: (required)
        :type configuration_id: str
        :param update_configuration0_request: Configuration attributes (required)
        :type update_configuration0_request: UpdateConfiguration0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_configuration0_serialize(
            configuration_id=configuration_id,
            update_configuration0_request=update_configuration0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateConfiguration0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_configuration0_without_preload_content(
        self,
        configuration_id: StrictStr,
        update_configuration0_request: Annotated[UpdateConfiguration0Request, Field(description="Configuration attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update_configuration0

        Update Configuration attributes

        :param configuration_id: (required)
        :type configuration_id: str
        :param update_configuration0_request: Configuration attributes (required)
        :type update_configuration0_request: UpdateConfiguration0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_configuration0_serialize(
            configuration_id=configuration_id,
            update_configuration0_request=update_configuration0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateConfiguration0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_configuration0_serialize(
        self,
        configuration_id,
        update_configuration0_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_configuration0_request is not None:
            _body_params = update_configuration0_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/configurations/{configuration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


