# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictFloat, StrictInt, StrictStr
from typing import Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_datastream_link201_response import CreateDatastreamLink201Response
from openapi_client.models.create_datastream_link_request import CreateDatastreamLinkRequest
from openapi_client.models.create_involved_device_for_datastream_link201_response import CreateInvolvedDeviceForDatastreamLink201Response
from openapi_client.models.create_involved_device_for_datastream_link_request import CreateInvolvedDeviceForDatastreamLinkRequest
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.models.retrieveacollectionof_datastream_link_objects200_response import RetrieveacollectionofDatastreamLinkObjects200Response
from openapi_client.models.retrievecollectionof_involved_devices_for_datastream_link_objects200_response import RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response
from openapi_client.models.update_datastream_link_object_request import UpdateDatastreamLinkObjectRequest
from openapi_client.models.update_involved_device_for_datastream_link_request import UpdateInvolvedDeviceForDatastreamLinkRequest

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType


class DatastreamLinksApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_datastream_link(
        self,
        create_datastream_link_request: CreateDatastreamLinkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateDatastreamLink201Response:
        """create_datastream_link


        :param create_datastream_link_request: (required)
        :type create_datastream_link_request: CreateDatastreamLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_datastream_link_serialize(
            create_datastream_link_request=create_datastream_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_datastream_link_with_http_info(
        self,
        create_datastream_link_request: CreateDatastreamLinkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateDatastreamLink201Response]:
        """create_datastream_link


        :param create_datastream_link_request: (required)
        :type create_datastream_link_request: CreateDatastreamLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_datastream_link_serialize(
            create_datastream_link_request=create_datastream_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_datastream_link_without_preload_content(
        self,
        create_datastream_link_request: CreateDatastreamLinkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create_datastream_link


        :param create_datastream_link_request: (required)
        :type create_datastream_link_request: CreateDatastreamLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_datastream_link_serialize(
            create_datastream_link_request=create_datastream_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_datastream_link_serialize(
        self,
        create_datastream_link_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_datastream_link_request is not None:
            _body_params = create_datastream_link_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/datastream-links',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_involved_device_for_datastream_link(
        self,
        create_involved_device_for_datastream_link_request: CreateInvolvedDeviceForDatastreamLinkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateInvolvedDeviceForDatastreamLink201Response:
        """create_involved_device_for_datastream_link


        :param create_involved_device_for_datastream_link_request: (required)
        :type create_involved_device_for_datastream_link_request: CreateInvolvedDeviceForDatastreamLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_involved_device_for_datastream_link_serialize(
            create_involved_device_for_datastream_link_request=create_involved_device_for_datastream_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateInvolvedDeviceForDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_involved_device_for_datastream_link_with_http_info(
        self,
        create_involved_device_for_datastream_link_request: CreateInvolvedDeviceForDatastreamLinkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateInvolvedDeviceForDatastreamLink201Response]:
        """create_involved_device_for_datastream_link


        :param create_involved_device_for_datastream_link_request: (required)
        :type create_involved_device_for_datastream_link_request: CreateInvolvedDeviceForDatastreamLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_involved_device_for_datastream_link_serialize(
            create_involved_device_for_datastream_link_request=create_involved_device_for_datastream_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateInvolvedDeviceForDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_involved_device_for_datastream_link_without_preload_content(
        self,
        create_involved_device_for_datastream_link_request: CreateInvolvedDeviceForDatastreamLinkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create_involved_device_for_datastream_link


        :param create_involved_device_for_datastream_link_request: (required)
        :type create_involved_device_for_datastream_link_request: CreateInvolvedDeviceForDatastreamLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_involved_device_for_datastream_link_serialize(
            create_involved_device_for_datastream_link_request=create_involved_device_for_datastream_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateInvolvedDeviceForDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_involved_device_for_datastream_link_serialize(
        self,
        create_involved_device_for_datastream_link_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_involved_device_for_datastream_link_request is not None:
            _body_params = create_involved_device_for_datastream_link_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/involved-devices-for-datastream-links',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_a_datastream_link_object(
        self,
        datastream_link_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteConfigurationAttachmentfromconfigurationattachment0200Response:
        """delete_a_datastream_link_object


        :param datastream_link_id: (required)
        :type datastream_link_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_a_datastream_link_object_serialize(
            datastream_link_id=datastream_link_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_a_datastream_link_object_with_http_info(
        self,
        datastream_link_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteConfigurationAttachmentfromconfigurationattachment0200Response]:
        """delete_a_datastream_link_object


        :param datastream_link_id: (required)
        :type datastream_link_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_a_datastream_link_object_serialize(
            datastream_link_id=datastream_link_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_a_datastream_link_object_without_preload_content(
        self,
        datastream_link_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete_a_datastream_link_object


        :param datastream_link_id: (required)
        :type datastream_link_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_a_datastream_link_object_serialize(
            datastream_link_id=datastream_link_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_a_datastream_link_object_serialize(
        self,
        datastream_link_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if datastream_link_id is not None:
            _path_params['datastream_link_id'] = datastream_link_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/datastream-links/{datastream_link_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_involved_device_for_datastream_link(
        self,
        involved_device_for_datastream_link_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteConfigurationAttachmentfromconfigurationattachment0200Response:
        """delete_involved_device_for_datastream_link


        :param involved_device_for_datastream_link_id: (required)
        :type involved_device_for_datastream_link_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_involved_device_for_datastream_link_serialize(
            involved_device_for_datastream_link_id=involved_device_for_datastream_link_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_involved_device_for_datastream_link_with_http_info(
        self,
        involved_device_for_datastream_link_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteConfigurationAttachmentfromconfigurationattachment0200Response]:
        """delete_involved_device_for_datastream_link


        :param involved_device_for_datastream_link_id: (required)
        :type involved_device_for_datastream_link_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_involved_device_for_datastream_link_serialize(
            involved_device_for_datastream_link_id=involved_device_for_datastream_link_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_involved_device_for_datastream_link_without_preload_content(
        self,
        involved_device_for_datastream_link_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete_involved_device_for_datastream_link


        :param involved_device_for_datastream_link_id: (required)
        :type involved_device_for_datastream_link_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_involved_device_for_datastream_link_serialize(
            involved_device_for_datastream_link_id=involved_device_for_datastream_link_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_involved_device_for_datastream_link_serialize(
        self,
        involved_device_for_datastream_link_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if involved_device_for_datastream_link_id is not None:
            _path_params['involved_device_for_datastream_link_id'] = involved_device_for_datastream_link_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/involved-devices-for-datastream-links/{involved_device_for_datastream_link_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieve_involved_device_for_datastream_link_instance(
        self,
        involved_device_for_datastream_link_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateInvolvedDeviceForDatastreamLink201Response:
        """retrieve_involved_device_for_datastream_link_instance

        Retrieve a single involved device for a datastream link

        :param involved_device_for_datastream_link_id: (required)
        :type involved_device_for_datastream_link_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_involved_device_for_datastream_link_instance_serialize(
            involved_device_for_datastream_link_id=involved_device_for_datastream_link_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateInvolvedDeviceForDatastreamLink201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieve_involved_device_for_datastream_link_instance_with_http_info(
        self,
        involved_device_for_datastream_link_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateInvolvedDeviceForDatastreamLink201Response]:
        """retrieve_involved_device_for_datastream_link_instance

        Retrieve a single involved device for a datastream link

        :param involved_device_for_datastream_link_id: (required)
        :type involved_device_for_datastream_link_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_involved_device_for_datastream_link_instance_serialize(
            involved_device_for_datastream_link_id=involved_device_for_datastream_link_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateInvolvedDeviceForDatastreamLink201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieve_involved_device_for_datastream_link_instance_without_preload_content(
        self,
        involved_device_for_datastream_link_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieve_involved_device_for_datastream_link_instance

        Retrieve a single involved device for a datastream link

        :param involved_device_for_datastream_link_id: (required)
        :type involved_device_for_datastream_link_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_involved_device_for_datastream_link_instance_serialize(
            involved_device_for_datastream_link_id=involved_device_for_datastream_link_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateInvolvedDeviceForDatastreamLink201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieve_involved_device_for_datastream_link_instance_serialize(
        self,
        involved_device_for_datastream_link_id,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if involved_device_for_datastream_link_id is not None:
            _path_params['involved_device_for_datastream_link_id'] = involved_device_for_datastream_link_id
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/involved-devices-for-datastream-links/{involved_device_for_datastream_link_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieveacollectionof_datastream_link_objects(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_begin_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_datasource_id: Optional[StrictStr] = None,
        filter_datasource_name: Optional[StrictStr] = None,
        filter_thing_id: Optional[StrictStr] = None,
        filter_thing_name: Optional[StrictStr] = None,
        filter_datastream_id: Optional[StrictStr] = None,
        filter_datastream_name: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_license_uri: Optional[StrictStr] = None,
        filter_license_name: Optional[StrictStr] = None,
        filter_aggregation_period: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_label: Optional[StrictStr] = None,
        filter_tsm_endpoint_id: Optional[StrictStr] = None,
        filter_device_property_id: Optional[StrictStr] = None,
        filter_device_mount_action_id: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RetrieveacollectionofDatastreamLinkObjects200Response:
        """retrieveacollectionof_datastream_link_objects

        Retrieve a collection of datastream link objects

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_begin_date:
        :type filter_begin_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_datasource_id:
        :type filter_datasource_id: str
        :param filter_datasource_name:
        :type filter_datasource_name: str
        :param filter_thing_id:
        :type filter_thing_id: str
        :param filter_thing_name:
        :type filter_thing_name: str
        :param filter_datastream_id:
        :type filter_datastream_id: str
        :param filter_datastream_name:
        :type filter_datastream_name: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_license_uri:
        :type filter_license_uri: str
        :param filter_license_name:
        :type filter_license_name: str
        :param filter_aggregation_period:
        :type filter_aggregation_period: float
        :param filter_label:
        :type filter_label: str
        :param filter_tsm_endpoint_id:
        :type filter_tsm_endpoint_id: str
        :param filter_device_property_id:
        :type filter_device_property_id: str
        :param filter_device_mount_action_id:
        :type filter_device_mount_action_id: str
        :param filter: Custom filter
        :type filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_datastream_link_objects_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_begin_date=filter_begin_date,
            filter_end_date=filter_end_date,
            filter_datasource_id=filter_datasource_id,
            filter_datasource_name=filter_datasource_name,
            filter_thing_id=filter_thing_id,
            filter_thing_name=filter_thing_name,
            filter_datastream_id=filter_datastream_id,
            filter_datastream_name=filter_datastream_name,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_license_uri=filter_license_uri,
            filter_license_name=filter_license_name,
            filter_aggregation_period=filter_aggregation_period,
            filter_label=filter_label,
            filter_tsm_endpoint_id=filter_tsm_endpoint_id,
            filter_device_property_id=filter_device_property_id,
            filter_device_mount_action_id=filter_device_mount_action_id,
            filter=filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofDatastreamLinkObjects200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieveacollectionof_datastream_link_objects_with_http_info(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_begin_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_datasource_id: Optional[StrictStr] = None,
        filter_datasource_name: Optional[StrictStr] = None,
        filter_thing_id: Optional[StrictStr] = None,
        filter_thing_name: Optional[StrictStr] = None,
        filter_datastream_id: Optional[StrictStr] = None,
        filter_datastream_name: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_license_uri: Optional[StrictStr] = None,
        filter_license_name: Optional[StrictStr] = None,
        filter_aggregation_period: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_label: Optional[StrictStr] = None,
        filter_tsm_endpoint_id: Optional[StrictStr] = None,
        filter_device_property_id: Optional[StrictStr] = None,
        filter_device_mount_action_id: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RetrieveacollectionofDatastreamLinkObjects200Response]:
        """retrieveacollectionof_datastream_link_objects

        Retrieve a collection of datastream link objects

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_begin_date:
        :type filter_begin_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_datasource_id:
        :type filter_datasource_id: str
        :param filter_datasource_name:
        :type filter_datasource_name: str
        :param filter_thing_id:
        :type filter_thing_id: str
        :param filter_thing_name:
        :type filter_thing_name: str
        :param filter_datastream_id:
        :type filter_datastream_id: str
        :param filter_datastream_name:
        :type filter_datastream_name: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_license_uri:
        :type filter_license_uri: str
        :param filter_license_name:
        :type filter_license_name: str
        :param filter_aggregation_period:
        :type filter_aggregation_period: float
        :param filter_label:
        :type filter_label: str
        :param filter_tsm_endpoint_id:
        :type filter_tsm_endpoint_id: str
        :param filter_device_property_id:
        :type filter_device_property_id: str
        :param filter_device_mount_action_id:
        :type filter_device_mount_action_id: str
        :param filter: Custom filter
        :type filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_datastream_link_objects_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_begin_date=filter_begin_date,
            filter_end_date=filter_end_date,
            filter_datasource_id=filter_datasource_id,
            filter_datasource_name=filter_datasource_name,
            filter_thing_id=filter_thing_id,
            filter_thing_name=filter_thing_name,
            filter_datastream_id=filter_datastream_id,
            filter_datastream_name=filter_datastream_name,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_license_uri=filter_license_uri,
            filter_license_name=filter_license_name,
            filter_aggregation_period=filter_aggregation_period,
            filter_label=filter_label,
            filter_tsm_endpoint_id=filter_tsm_endpoint_id,
            filter_device_property_id=filter_device_property_id,
            filter_device_mount_action_id=filter_device_mount_action_id,
            filter=filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofDatastreamLinkObjects200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieveacollectionof_datastream_link_objects_without_preload_content(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_begin_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_datasource_id: Optional[StrictStr] = None,
        filter_datasource_name: Optional[StrictStr] = None,
        filter_thing_id: Optional[StrictStr] = None,
        filter_thing_name: Optional[StrictStr] = None,
        filter_datastream_id: Optional[StrictStr] = None,
        filter_datastream_name: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_license_uri: Optional[StrictStr] = None,
        filter_license_name: Optional[StrictStr] = None,
        filter_aggregation_period: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_label: Optional[StrictStr] = None,
        filter_tsm_endpoint_id: Optional[StrictStr] = None,
        filter_device_property_id: Optional[StrictStr] = None,
        filter_device_mount_action_id: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieveacollectionof_datastream_link_objects

        Retrieve a collection of datastream link objects

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_begin_date:
        :type filter_begin_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_datasource_id:
        :type filter_datasource_id: str
        :param filter_datasource_name:
        :type filter_datasource_name: str
        :param filter_thing_id:
        :type filter_thing_id: str
        :param filter_thing_name:
        :type filter_thing_name: str
        :param filter_datastream_id:
        :type filter_datastream_id: str
        :param filter_datastream_name:
        :type filter_datastream_name: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_license_uri:
        :type filter_license_uri: str
        :param filter_license_name:
        :type filter_license_name: str
        :param filter_aggregation_period:
        :type filter_aggregation_period: float
        :param filter_label:
        :type filter_label: str
        :param filter_tsm_endpoint_id:
        :type filter_tsm_endpoint_id: str
        :param filter_device_property_id:
        :type filter_device_property_id: str
        :param filter_device_mount_action_id:
        :type filter_device_mount_action_id: str
        :param filter: Custom filter
        :type filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_datastream_link_objects_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_begin_date=filter_begin_date,
            filter_end_date=filter_end_date,
            filter_datasource_id=filter_datasource_id,
            filter_datasource_name=filter_datasource_name,
            filter_thing_id=filter_thing_id,
            filter_thing_name=filter_thing_name,
            filter_datastream_id=filter_datastream_id,
            filter_datastream_name=filter_datastream_name,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_license_uri=filter_license_uri,
            filter_license_name=filter_license_name,
            filter_aggregation_period=filter_aggregation_period,
            filter_label=filter_label,
            filter_tsm_endpoint_id=filter_tsm_endpoint_id,
            filter_device_property_id=filter_device_property_id,
            filter_device_mount_action_id=filter_device_mount_action_id,
            filter=filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofDatastreamLinkObjects200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieveacollectionof_datastream_link_objects_serialize(
        self,
        include,
        page_number,
        page_size,
        sort,
        filter_id,
        filter_begin_date,
        filter_end_date,
        filter_datasource_id,
        filter_datasource_name,
        filter_thing_id,
        filter_thing_name,
        filter_datastream_id,
        filter_datastream_name,
        filter_created_at,
        filter_updated_at,
        filter_license_uri,
        filter_license_name,
        filter_aggregation_period,
        filter_label,
        filter_tsm_endpoint_id,
        filter_device_property_id,
        filter_device_mount_action_id,
        filter,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        if page_number is not None:
            
            _query_params.append(('page[number]', page_number))
            
        if page_size is not None:
            
            _query_params.append(('page[size]', page_size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if filter_id is not None:
            
            _query_params.append(('filter[id]', filter_id))
            
        if filter_begin_date is not None:
            if isinstance(filter_begin_date, datetime):
                _query_params.append(
                    (
                        'filter[begin_date]',
                        filter_begin_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[begin_date]', filter_begin_date))
            
        if filter_end_date is not None:
            if isinstance(filter_end_date, datetime):
                _query_params.append(
                    (
                        'filter[end_date]',
                        filter_end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[end_date]', filter_end_date))
            
        if filter_datasource_id is not None:
            
            _query_params.append(('filter[datasource_id]', filter_datasource_id))
            
        if filter_datasource_name is not None:
            
            _query_params.append(('filter[datasource_name]', filter_datasource_name))
            
        if filter_thing_id is not None:
            
            _query_params.append(('filter[thing_id]', filter_thing_id))
            
        if filter_thing_name is not None:
            
            _query_params.append(('filter[thing_name]', filter_thing_name))
            
        if filter_datastream_id is not None:
            
            _query_params.append(('filter[datastream_id]', filter_datastream_id))
            
        if filter_datastream_name is not None:
            
            _query_params.append(('filter[datastream_name]', filter_datastream_name))
            
        if filter_created_at is not None:
            if isinstance(filter_created_at, datetime):
                _query_params.append(
                    (
                        'filter[created_at]',
                        filter_created_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[created_at]', filter_created_at))
            
        if filter_updated_at is not None:
            if isinstance(filter_updated_at, datetime):
                _query_params.append(
                    (
                        'filter[updated_at]',
                        filter_updated_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[updated_at]', filter_updated_at))
            
        if filter_license_uri is not None:
            
            _query_params.append(('filter[license_uri]', filter_license_uri))
            
        if filter_license_name is not None:
            
            _query_params.append(('filter[license_name]', filter_license_name))
            
        if filter_aggregation_period is not None:
            
            _query_params.append(('filter[aggregation_period]', filter_aggregation_period))
            
        if filter_label is not None:
            
            _query_params.append(('filter[label]', filter_label))
            
        if filter_tsm_endpoint_id is not None:
            
            _query_params.append(('filter[tsm_endpoint_id]', filter_tsm_endpoint_id))
            
        if filter_device_property_id is not None:
            
            _query_params.append(('filter[device_property_id]', filter_device_property_id))
            
        if filter_device_mount_action_id is not None:
            
            _query_params.append(('filter[device_mount_action_id]', filter_device_mount_action_id))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/datastream-links',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrievecollectionof_involved_devices_for_datastream_link_objects(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_order_index: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_device_id: Optional[StrictStr] = None,
        filter_datastream_link_id: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response:
        """retrievecollectionof_involved_devices_for_datastream_link_objects

        Retrieve a list of involved devices for datastream links

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_order_index:
        :type filter_order_index: float
        :param filter_device_id:
        :type filter_device_id: str
        :param filter_datastream_link_id:
        :type filter_datastream_link_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrievecollectionof_involved_devices_for_datastream_link_objects_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_order_index=filter_order_index,
            filter_device_id=filter_device_id,
            filter_datastream_link_id=filter_datastream_link_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrievecollectionof_involved_devices_for_datastream_link_objects_with_http_info(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_order_index: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_device_id: Optional[StrictStr] = None,
        filter_datastream_link_id: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response]:
        """retrievecollectionof_involved_devices_for_datastream_link_objects

        Retrieve a list of involved devices for datastream links

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_order_index:
        :type filter_order_index: float
        :param filter_device_id:
        :type filter_device_id: str
        :param filter_datastream_link_id:
        :type filter_datastream_link_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrievecollectionof_involved_devices_for_datastream_link_objects_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_order_index=filter_order_index,
            filter_device_id=filter_device_id,
            filter_datastream_link_id=filter_datastream_link_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrievecollectionof_involved_devices_for_datastream_link_objects_without_preload_content(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_order_index: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_device_id: Optional[StrictStr] = None,
        filter_datastream_link_id: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrievecollectionof_involved_devices_for_datastream_link_objects

        Retrieve a list of involved devices for datastream links

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_order_index:
        :type filter_order_index: float
        :param filter_device_id:
        :type filter_device_id: str
        :param filter_datastream_link_id:
        :type filter_datastream_link_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrievecollectionof_involved_devices_for_datastream_link_objects_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_order_index=filter_order_index,
            filter_device_id=filter_device_id,
            filter_datastream_link_id=filter_datastream_link_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrievecollectionofInvolvedDevicesForDatastreamLinkObjects200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrievecollectionof_involved_devices_for_datastream_link_objects_serialize(
        self,
        include,
        page_number,
        page_size,
        sort,
        filter_id,
        filter_order_index,
        filter_device_id,
        filter_datastream_link_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        if page_number is not None:
            
            _query_params.append(('page[number]', page_number))
            
        if page_size is not None:
            
            _query_params.append(('page[size]', page_size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if filter_id is not None:
            
            _query_params.append(('filter[id]', filter_id))
            
        if filter_order_index is not None:
            
            _query_params.append(('filter[order_index]', filter_order_index))
            
        if filter_device_id is not None:
            
            _query_params.append(('filter[device_id]', filter_device_id))
            
        if filter_datastream_link_id is not None:
            
            _query_params.append(('filter[datastream_link_id]', filter_datastream_link_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/involved-devices-for-datastream-links',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieveinstanceof_datastream_link_object(
        self,
        datastream_link_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateDatastreamLink201Response:
        """retrieveinstanceof_datastream_link_object

        Retrieve a single datastream link object

        :param datastream_link_id: (required)
        :type datastream_link_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveinstanceof_datastream_link_object_serialize(
            datastream_link_id=datastream_link_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieveinstanceof_datastream_link_object_with_http_info(
        self,
        datastream_link_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateDatastreamLink201Response]:
        """retrieveinstanceof_datastream_link_object

        Retrieve a single datastream link object

        :param datastream_link_id: (required)
        :type datastream_link_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveinstanceof_datastream_link_object_serialize(
            datastream_link_id=datastream_link_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieveinstanceof_datastream_link_object_without_preload_content(
        self,
        datastream_link_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieveinstanceof_datastream_link_object

        Retrieve a single datastream link object

        :param datastream_link_id: (required)
        :type datastream_link_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveinstanceof_datastream_link_object_serialize(
            datastream_link_id=datastream_link_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieveinstanceof_datastream_link_object_serialize(
        self,
        datastream_link_id,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if datastream_link_id is not None:
            _path_params['datastream_link_id'] = datastream_link_id
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/datastream-links/{datastream_link_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_datastream_link_object(
        self,
        datastream_link_id: StrictStr,
        update_datastream_link_object_request: Annotated[UpdateDatastreamLinkObjectRequest, Field(description="Datastream link attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateDatastreamLink201Response:
        """update_datastream_link_object

        Update a datastream link object

        :param datastream_link_id: (required)
        :type datastream_link_id: str
        :param update_datastream_link_object_request: Datastream link attributes (required)
        :type update_datastream_link_object_request: UpdateDatastreamLinkObjectRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_datastream_link_object_serialize(
            datastream_link_id=datastream_link_id,
            update_datastream_link_object_request=update_datastream_link_object_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_datastream_link_object_with_http_info(
        self,
        datastream_link_id: StrictStr,
        update_datastream_link_object_request: Annotated[UpdateDatastreamLinkObjectRequest, Field(description="Datastream link attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateDatastreamLink201Response]:
        """update_datastream_link_object

        Update a datastream link object

        :param datastream_link_id: (required)
        :type datastream_link_id: str
        :param update_datastream_link_object_request: Datastream link attributes (required)
        :type update_datastream_link_object_request: UpdateDatastreamLinkObjectRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_datastream_link_object_serialize(
            datastream_link_id=datastream_link_id,
            update_datastream_link_object_request=update_datastream_link_object_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_datastream_link_object_without_preload_content(
        self,
        datastream_link_id: StrictStr,
        update_datastream_link_object_request: Annotated[UpdateDatastreamLinkObjectRequest, Field(description="Datastream link attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update_datastream_link_object

        Update a datastream link object

        :param datastream_link_id: (required)
        :type datastream_link_id: str
        :param update_datastream_link_object_request: Datastream link attributes (required)
        :type update_datastream_link_object_request: UpdateDatastreamLinkObjectRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_datastream_link_object_serialize(
            datastream_link_id=datastream_link_id,
            update_datastream_link_object_request=update_datastream_link_object_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDatastreamLink201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_datastream_link_object_serialize(
        self,
        datastream_link_id,
        update_datastream_link_object_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if datastream_link_id is not None:
            _path_params['datastream_link_id'] = datastream_link_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_datastream_link_object_request is not None:
            _body_params = update_datastream_link_object_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/datastream-links/{datastream_link_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_involved_device_for_datastream_link(
        self,
        involved_device_for_datastream_link_id: StrictStr,
        update_involved_device_for_datastream_link_request: Annotated[UpdateInvolvedDeviceForDatastreamLinkRequest, Field(description="InvolvedDeviceForDatastream attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateInvolvedDeviceForDatastreamLink201Response:
        """update_involved_device_for_datastream_link

        Update InvolvedDeviceForDatastreamLink attributes

        :param involved_device_for_datastream_link_id: (required)
        :type involved_device_for_datastream_link_id: str
        :param update_involved_device_for_datastream_link_request: InvolvedDeviceForDatastream attributes (required)
        :type update_involved_device_for_datastream_link_request: UpdateInvolvedDeviceForDatastreamLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_involved_device_for_datastream_link_serialize(
            involved_device_for_datastream_link_id=involved_device_for_datastream_link_id,
            update_involved_device_for_datastream_link_request=update_involved_device_for_datastream_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateInvolvedDeviceForDatastreamLink201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_involved_device_for_datastream_link_with_http_info(
        self,
        involved_device_for_datastream_link_id: StrictStr,
        update_involved_device_for_datastream_link_request: Annotated[UpdateInvolvedDeviceForDatastreamLinkRequest, Field(description="InvolvedDeviceForDatastream attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateInvolvedDeviceForDatastreamLink201Response]:
        """update_involved_device_for_datastream_link

        Update InvolvedDeviceForDatastreamLink attributes

        :param involved_device_for_datastream_link_id: (required)
        :type involved_device_for_datastream_link_id: str
        :param update_involved_device_for_datastream_link_request: InvolvedDeviceForDatastream attributes (required)
        :type update_involved_device_for_datastream_link_request: UpdateInvolvedDeviceForDatastreamLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_involved_device_for_datastream_link_serialize(
            involved_device_for_datastream_link_id=involved_device_for_datastream_link_id,
            update_involved_device_for_datastream_link_request=update_involved_device_for_datastream_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateInvolvedDeviceForDatastreamLink201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_involved_device_for_datastream_link_without_preload_content(
        self,
        involved_device_for_datastream_link_id: StrictStr,
        update_involved_device_for_datastream_link_request: Annotated[UpdateInvolvedDeviceForDatastreamLinkRequest, Field(description="InvolvedDeviceForDatastream attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update_involved_device_for_datastream_link

        Update InvolvedDeviceForDatastreamLink attributes

        :param involved_device_for_datastream_link_id: (required)
        :type involved_device_for_datastream_link_id: str
        :param update_involved_device_for_datastream_link_request: InvolvedDeviceForDatastream attributes (required)
        :type update_involved_device_for_datastream_link_request: UpdateInvolvedDeviceForDatastreamLinkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_involved_device_for_datastream_link_serialize(
            involved_device_for_datastream_link_id=involved_device_for_datastream_link_id,
            update_involved_device_for_datastream_link_request=update_involved_device_for_datastream_link_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateInvolvedDeviceForDatastreamLink201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_involved_device_for_datastream_link_serialize(
        self,
        involved_device_for_datastream_link_id,
        update_involved_device_for_datastream_link_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if involved_device_for_datastream_link_id is not None:
            _path_params['involved_device_for_datastream_link_id'] = involved_device_for_datastream_link_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_involved_device_for_datastream_link_request is not None:
            _body_params = update_involved_device_for_datastream_link_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/involved-devices-for-datastream-links/{involved_device_for_datastream_link_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


