# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictFloat, StrictInt, StrictStr
from typing import Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_device_property0201_response import CreateDeviceProperty0201Response
from openapi_client.models.create_device_property0_request import CreateDeviceProperty0Request
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.models.retrieveacollectionof_device_propertyobjects0200_response import RetrieveacollectionofDevicePropertyobjects0200Response
from openapi_client.models.update_device_property0_request import UpdateDeviceProperty0Request

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType


class DevicePropertiesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_device_property0(
        self,
        create_device_property0_request: CreateDeviceProperty0Request,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateDeviceProperty0201Response:
        """create_device_property0


        :param create_device_property0_request: (required)
        :type create_device_property0_request: CreateDeviceProperty0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_device_property0_serialize(
            create_device_property0_request=create_device_property0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateDeviceProperty0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_device_property0_with_http_info(
        self,
        create_device_property0_request: CreateDeviceProperty0Request,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateDeviceProperty0201Response]:
        """create_device_property0


        :param create_device_property0_request: (required)
        :type create_device_property0_request: CreateDeviceProperty0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_device_property0_serialize(
            create_device_property0_request=create_device_property0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateDeviceProperty0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_device_property0_without_preload_content(
        self,
        create_device_property0_request: CreateDeviceProperty0Request,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create_device_property0


        :param create_device_property0_request: (required)
        :type create_device_property0_request: CreateDeviceProperty0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_device_property0_serialize(
            create_device_property0_request=create_device_property0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateDeviceProperty0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_device_property0_serialize(
        self,
        create_device_property0_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_device_property0_request is not None:
            _body_params = create_device_property0_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/device-properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_device_propertyfromdeviceproperty1(
        self,
        device_property_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteConfigurationAttachmentfromconfigurationattachment0200Response:
        """delete_device_propertyfromdeviceproperty1


        :param device_property_id: (required)
        :type device_property_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_device_propertyfromdeviceproperty1_serialize(
            device_property_id=device_property_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_device_propertyfromdeviceproperty1_with_http_info(
        self,
        device_property_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteConfigurationAttachmentfromconfigurationattachment0200Response]:
        """delete_device_propertyfromdeviceproperty1


        :param device_property_id: (required)
        :type device_property_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_device_propertyfromdeviceproperty1_serialize(
            device_property_id=device_property_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_device_propertyfromdeviceproperty1_without_preload_content(
        self,
        device_property_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete_device_propertyfromdeviceproperty1


        :param device_property_id: (required)
        :type device_property_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_device_propertyfromdeviceproperty1_serialize(
            device_property_id=device_property_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_device_propertyfromdeviceproperty1_serialize(
        self,
        device_property_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if device_property_id is not None:
            _path_params['device_property_id'] = device_property_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/device-properties/{device_property_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieve_device_propertyinstance0(
        self,
        device_property_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateDeviceProperty0201Response:
        """retrieve_device_propertyinstance0

        Retrieve DeviceProperty from device_property

        :param device_property_id: (required)
        :type device_property_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_device_propertyinstance0_serialize(
            device_property_id=device_property_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDeviceProperty0201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieve_device_propertyinstance0_with_http_info(
        self,
        device_property_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateDeviceProperty0201Response]:
        """retrieve_device_propertyinstance0

        Retrieve DeviceProperty from device_property

        :param device_property_id: (required)
        :type device_property_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_device_propertyinstance0_serialize(
            device_property_id=device_property_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDeviceProperty0201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieve_device_propertyinstance0_without_preload_content(
        self,
        device_property_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieve_device_propertyinstance0

        Retrieve DeviceProperty from device_property

        :param device_property_id: (required)
        :type device_property_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_device_propertyinstance0_serialize(
            device_property_id=device_property_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDeviceProperty0201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieve_device_propertyinstance0_serialize(
        self,
        device_property_id,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if device_property_id is not None:
            _path_params['device_property_id'] = device_property_id
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/device-properties/{device_property_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieveacollectionof_device_propertyobjects0(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_measuring_range_min: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_measuring_range_max: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_failure_value: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_accuracy: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_label: Optional[StrictStr] = None,
        filter_accuracy_unit_uri: Optional[StrictStr] = None,
        filter_accuracy_unit_name: Optional[StrictStr] = None,
        filter_unit_uri: Optional[StrictStr] = None,
        filter_unit_name: Optional[StrictStr] = None,
        filter_compartment_uri: Optional[StrictStr] = None,
        filter_compartment_name: Optional[StrictStr] = None,
        filter_property_uri: Optional[StrictStr] = None,
        filter_property_name: Optional[StrictStr] = None,
        filter_sampling_media_uri: Optional[StrictStr] = None,
        filter_sampling_media_name: Optional[StrictStr] = None,
        filter_resolution: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_resolution_unit_uri: Optional[StrictStr] = None,
        filter_resolution_unit_name: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_aggregation_type_uri: Optional[StrictStr] = None,
        filter_aggregation_type_name: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_device_id: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RetrieveacollectionofDevicePropertyobjects0200Response:
        """retrieveacollectionof_device_propertyobjects0

        Retrieve DeviceProperty from device_property

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_measuring_range_min:
        :type filter_measuring_range_min: float
        :param filter_measuring_range_max:
        :type filter_measuring_range_max: float
        :param filter_failure_value:
        :type filter_failure_value: float
        :param filter_accuracy:
        :type filter_accuracy: float
        :param filter_label:
        :type filter_label: str
        :param filter_accuracy_unit_uri:
        :type filter_accuracy_unit_uri: str
        :param filter_accuracy_unit_name:
        :type filter_accuracy_unit_name: str
        :param filter_unit_uri:
        :type filter_unit_uri: str
        :param filter_unit_name:
        :type filter_unit_name: str
        :param filter_compartment_uri:
        :type filter_compartment_uri: str
        :param filter_compartment_name:
        :type filter_compartment_name: str
        :param filter_property_uri:
        :type filter_property_uri: str
        :param filter_property_name:
        :type filter_property_name: str
        :param filter_sampling_media_uri:
        :type filter_sampling_media_uri: str
        :param filter_sampling_media_name:
        :type filter_sampling_media_name: str
        :param filter_resolution:
        :type filter_resolution: float
        :param filter_resolution_unit_uri:
        :type filter_resolution_unit_uri: str
        :param filter_resolution_unit_name:
        :type filter_resolution_unit_name: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_aggregation_type_uri:
        :type filter_aggregation_type_uri: str
        :param filter_aggregation_type_name:
        :type filter_aggregation_type_name: str
        :param filter_description:
        :type filter_description: str
        :param filter_device_id:
        :type filter_device_id: str
        :param filter: Custom filter
        :type filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_device_propertyobjects0_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_measuring_range_min=filter_measuring_range_min,
            filter_measuring_range_max=filter_measuring_range_max,
            filter_failure_value=filter_failure_value,
            filter_accuracy=filter_accuracy,
            filter_label=filter_label,
            filter_accuracy_unit_uri=filter_accuracy_unit_uri,
            filter_accuracy_unit_name=filter_accuracy_unit_name,
            filter_unit_uri=filter_unit_uri,
            filter_unit_name=filter_unit_name,
            filter_compartment_uri=filter_compartment_uri,
            filter_compartment_name=filter_compartment_name,
            filter_property_uri=filter_property_uri,
            filter_property_name=filter_property_name,
            filter_sampling_media_uri=filter_sampling_media_uri,
            filter_sampling_media_name=filter_sampling_media_name,
            filter_resolution=filter_resolution,
            filter_resolution_unit_uri=filter_resolution_unit_uri,
            filter_resolution_unit_name=filter_resolution_unit_name,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_aggregation_type_uri=filter_aggregation_type_uri,
            filter_aggregation_type_name=filter_aggregation_type_name,
            filter_description=filter_description,
            filter_device_id=filter_device_id,
            filter=filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofDevicePropertyobjects0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieveacollectionof_device_propertyobjects0_with_http_info(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_measuring_range_min: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_measuring_range_max: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_failure_value: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_accuracy: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_label: Optional[StrictStr] = None,
        filter_accuracy_unit_uri: Optional[StrictStr] = None,
        filter_accuracy_unit_name: Optional[StrictStr] = None,
        filter_unit_uri: Optional[StrictStr] = None,
        filter_unit_name: Optional[StrictStr] = None,
        filter_compartment_uri: Optional[StrictStr] = None,
        filter_compartment_name: Optional[StrictStr] = None,
        filter_property_uri: Optional[StrictStr] = None,
        filter_property_name: Optional[StrictStr] = None,
        filter_sampling_media_uri: Optional[StrictStr] = None,
        filter_sampling_media_name: Optional[StrictStr] = None,
        filter_resolution: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_resolution_unit_uri: Optional[StrictStr] = None,
        filter_resolution_unit_name: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_aggregation_type_uri: Optional[StrictStr] = None,
        filter_aggregation_type_name: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_device_id: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RetrieveacollectionofDevicePropertyobjects0200Response]:
        """retrieveacollectionof_device_propertyobjects0

        Retrieve DeviceProperty from device_property

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_measuring_range_min:
        :type filter_measuring_range_min: float
        :param filter_measuring_range_max:
        :type filter_measuring_range_max: float
        :param filter_failure_value:
        :type filter_failure_value: float
        :param filter_accuracy:
        :type filter_accuracy: float
        :param filter_label:
        :type filter_label: str
        :param filter_accuracy_unit_uri:
        :type filter_accuracy_unit_uri: str
        :param filter_accuracy_unit_name:
        :type filter_accuracy_unit_name: str
        :param filter_unit_uri:
        :type filter_unit_uri: str
        :param filter_unit_name:
        :type filter_unit_name: str
        :param filter_compartment_uri:
        :type filter_compartment_uri: str
        :param filter_compartment_name:
        :type filter_compartment_name: str
        :param filter_property_uri:
        :type filter_property_uri: str
        :param filter_property_name:
        :type filter_property_name: str
        :param filter_sampling_media_uri:
        :type filter_sampling_media_uri: str
        :param filter_sampling_media_name:
        :type filter_sampling_media_name: str
        :param filter_resolution:
        :type filter_resolution: float
        :param filter_resolution_unit_uri:
        :type filter_resolution_unit_uri: str
        :param filter_resolution_unit_name:
        :type filter_resolution_unit_name: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_aggregation_type_uri:
        :type filter_aggregation_type_uri: str
        :param filter_aggregation_type_name:
        :type filter_aggregation_type_name: str
        :param filter_description:
        :type filter_description: str
        :param filter_device_id:
        :type filter_device_id: str
        :param filter: Custom filter
        :type filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_device_propertyobjects0_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_measuring_range_min=filter_measuring_range_min,
            filter_measuring_range_max=filter_measuring_range_max,
            filter_failure_value=filter_failure_value,
            filter_accuracy=filter_accuracy,
            filter_label=filter_label,
            filter_accuracy_unit_uri=filter_accuracy_unit_uri,
            filter_accuracy_unit_name=filter_accuracy_unit_name,
            filter_unit_uri=filter_unit_uri,
            filter_unit_name=filter_unit_name,
            filter_compartment_uri=filter_compartment_uri,
            filter_compartment_name=filter_compartment_name,
            filter_property_uri=filter_property_uri,
            filter_property_name=filter_property_name,
            filter_sampling_media_uri=filter_sampling_media_uri,
            filter_sampling_media_name=filter_sampling_media_name,
            filter_resolution=filter_resolution,
            filter_resolution_unit_uri=filter_resolution_unit_uri,
            filter_resolution_unit_name=filter_resolution_unit_name,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_aggregation_type_uri=filter_aggregation_type_uri,
            filter_aggregation_type_name=filter_aggregation_type_name,
            filter_description=filter_description,
            filter_device_id=filter_device_id,
            filter=filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofDevicePropertyobjects0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieveacollectionof_device_propertyobjects0_without_preload_content(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_measuring_range_min: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_measuring_range_max: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_failure_value: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_accuracy: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_label: Optional[StrictStr] = None,
        filter_accuracy_unit_uri: Optional[StrictStr] = None,
        filter_accuracy_unit_name: Optional[StrictStr] = None,
        filter_unit_uri: Optional[StrictStr] = None,
        filter_unit_name: Optional[StrictStr] = None,
        filter_compartment_uri: Optional[StrictStr] = None,
        filter_compartment_name: Optional[StrictStr] = None,
        filter_property_uri: Optional[StrictStr] = None,
        filter_property_name: Optional[StrictStr] = None,
        filter_sampling_media_uri: Optional[StrictStr] = None,
        filter_sampling_media_name: Optional[StrictStr] = None,
        filter_resolution: Optional[Union[StrictFloat, StrictInt]] = None,
        filter_resolution_unit_uri: Optional[StrictStr] = None,
        filter_resolution_unit_name: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_aggregation_type_uri: Optional[StrictStr] = None,
        filter_aggregation_type_name: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_device_id: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieveacollectionof_device_propertyobjects0

        Retrieve DeviceProperty from device_property

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_measuring_range_min:
        :type filter_measuring_range_min: float
        :param filter_measuring_range_max:
        :type filter_measuring_range_max: float
        :param filter_failure_value:
        :type filter_failure_value: float
        :param filter_accuracy:
        :type filter_accuracy: float
        :param filter_label:
        :type filter_label: str
        :param filter_accuracy_unit_uri:
        :type filter_accuracy_unit_uri: str
        :param filter_accuracy_unit_name:
        :type filter_accuracy_unit_name: str
        :param filter_unit_uri:
        :type filter_unit_uri: str
        :param filter_unit_name:
        :type filter_unit_name: str
        :param filter_compartment_uri:
        :type filter_compartment_uri: str
        :param filter_compartment_name:
        :type filter_compartment_name: str
        :param filter_property_uri:
        :type filter_property_uri: str
        :param filter_property_name:
        :type filter_property_name: str
        :param filter_sampling_media_uri:
        :type filter_sampling_media_uri: str
        :param filter_sampling_media_name:
        :type filter_sampling_media_name: str
        :param filter_resolution:
        :type filter_resolution: float
        :param filter_resolution_unit_uri:
        :type filter_resolution_unit_uri: str
        :param filter_resolution_unit_name:
        :type filter_resolution_unit_name: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_aggregation_type_uri:
        :type filter_aggregation_type_uri: str
        :param filter_aggregation_type_name:
        :type filter_aggregation_type_name: str
        :param filter_description:
        :type filter_description: str
        :param filter_device_id:
        :type filter_device_id: str
        :param filter: Custom filter
        :type filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_device_propertyobjects0_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_measuring_range_min=filter_measuring_range_min,
            filter_measuring_range_max=filter_measuring_range_max,
            filter_failure_value=filter_failure_value,
            filter_accuracy=filter_accuracy,
            filter_label=filter_label,
            filter_accuracy_unit_uri=filter_accuracy_unit_uri,
            filter_accuracy_unit_name=filter_accuracy_unit_name,
            filter_unit_uri=filter_unit_uri,
            filter_unit_name=filter_unit_name,
            filter_compartment_uri=filter_compartment_uri,
            filter_compartment_name=filter_compartment_name,
            filter_property_uri=filter_property_uri,
            filter_property_name=filter_property_name,
            filter_sampling_media_uri=filter_sampling_media_uri,
            filter_sampling_media_name=filter_sampling_media_name,
            filter_resolution=filter_resolution,
            filter_resolution_unit_uri=filter_resolution_unit_uri,
            filter_resolution_unit_name=filter_resolution_unit_name,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_aggregation_type_uri=filter_aggregation_type_uri,
            filter_aggregation_type_name=filter_aggregation_type_name,
            filter_description=filter_description,
            filter_device_id=filter_device_id,
            filter=filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofDevicePropertyobjects0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieveacollectionof_device_propertyobjects0_serialize(
        self,
        include,
        page_number,
        page_size,
        sort,
        filter_id,
        filter_measuring_range_min,
        filter_measuring_range_max,
        filter_failure_value,
        filter_accuracy,
        filter_label,
        filter_accuracy_unit_uri,
        filter_accuracy_unit_name,
        filter_unit_uri,
        filter_unit_name,
        filter_compartment_uri,
        filter_compartment_name,
        filter_property_uri,
        filter_property_name,
        filter_sampling_media_uri,
        filter_sampling_media_name,
        filter_resolution,
        filter_resolution_unit_uri,
        filter_resolution_unit_name,
        filter_created_at,
        filter_updated_at,
        filter_aggregation_type_uri,
        filter_aggregation_type_name,
        filter_description,
        filter_device_id,
        filter,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        if page_number is not None:
            
            _query_params.append(('page[number]', page_number))
            
        if page_size is not None:
            
            _query_params.append(('page[size]', page_size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if filter_id is not None:
            
            _query_params.append(('filter[id]', filter_id))
            
        if filter_measuring_range_min is not None:
            
            _query_params.append(('filter[measuring_range_min]', filter_measuring_range_min))
            
        if filter_measuring_range_max is not None:
            
            _query_params.append(('filter[measuring_range_max]', filter_measuring_range_max))
            
        if filter_failure_value is not None:
            
            _query_params.append(('filter[failure_value]', filter_failure_value))
            
        if filter_accuracy is not None:
            
            _query_params.append(('filter[accuracy]', filter_accuracy))
            
        if filter_label is not None:
            
            _query_params.append(('filter[label]', filter_label))
            
        if filter_accuracy_unit_uri is not None:
            
            _query_params.append(('filter[accuracy_unit_uri]', filter_accuracy_unit_uri))
            
        if filter_accuracy_unit_name is not None:
            
            _query_params.append(('filter[accuracy_unit_name]', filter_accuracy_unit_name))
            
        if filter_unit_uri is not None:
            
            _query_params.append(('filter[unit_uri]', filter_unit_uri))
            
        if filter_unit_name is not None:
            
            _query_params.append(('filter[unit_name]', filter_unit_name))
            
        if filter_compartment_uri is not None:
            
            _query_params.append(('filter[compartment_uri]', filter_compartment_uri))
            
        if filter_compartment_name is not None:
            
            _query_params.append(('filter[compartment_name]', filter_compartment_name))
            
        if filter_property_uri is not None:
            
            _query_params.append(('filter[property_uri]', filter_property_uri))
            
        if filter_property_name is not None:
            
            _query_params.append(('filter[property_name]', filter_property_name))
            
        if filter_sampling_media_uri is not None:
            
            _query_params.append(('filter[sampling_media_uri]', filter_sampling_media_uri))
            
        if filter_sampling_media_name is not None:
            
            _query_params.append(('filter[sampling_media_name]', filter_sampling_media_name))
            
        if filter_resolution is not None:
            
            _query_params.append(('filter[resolution]', filter_resolution))
            
        if filter_resolution_unit_uri is not None:
            
            _query_params.append(('filter[resolution_unit_uri]', filter_resolution_unit_uri))
            
        if filter_resolution_unit_name is not None:
            
            _query_params.append(('filter[resolution_unit_name]', filter_resolution_unit_name))
            
        if filter_created_at is not None:
            if isinstance(filter_created_at, datetime):
                _query_params.append(
                    (
                        'filter[created_at]',
                        filter_created_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[created_at]', filter_created_at))
            
        if filter_updated_at is not None:
            if isinstance(filter_updated_at, datetime):
                _query_params.append(
                    (
                        'filter[updated_at]',
                        filter_updated_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[updated_at]', filter_updated_at))
            
        if filter_aggregation_type_uri is not None:
            
            _query_params.append(('filter[aggregation_type_uri]', filter_aggregation_type_uri))
            
        if filter_aggregation_type_name is not None:
            
            _query_params.append(('filter[aggregation_type_name]', filter_aggregation_type_name))
            
        if filter_description is not None:
            
            _query_params.append(('filter[description]', filter_description))
            
        if filter_device_id is not None:
            
            _query_params.append(('filter[device_id]', filter_device_id))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/device-properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_device_property0(
        self,
        device_property_id: StrictStr,
        update_device_property0_request: Annotated[UpdateDeviceProperty0Request, Field(description="DeviceProperty attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateDeviceProperty0201Response:
        """update_device_property0

        Update DeviceProperty attributes

        :param device_property_id: (required)
        :type device_property_id: str
        :param update_device_property0_request: DeviceProperty attributes (required)
        :type update_device_property0_request: UpdateDeviceProperty0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_device_property0_serialize(
            device_property_id=device_property_id,
            update_device_property0_request=update_device_property0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDeviceProperty0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_device_property0_with_http_info(
        self,
        device_property_id: StrictStr,
        update_device_property0_request: Annotated[UpdateDeviceProperty0Request, Field(description="DeviceProperty attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateDeviceProperty0201Response]:
        """update_device_property0

        Update DeviceProperty attributes

        :param device_property_id: (required)
        :type device_property_id: str
        :param update_device_property0_request: DeviceProperty attributes (required)
        :type update_device_property0_request: UpdateDeviceProperty0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_device_property0_serialize(
            device_property_id=device_property_id,
            update_device_property0_request=update_device_property0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDeviceProperty0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_device_property0_without_preload_content(
        self,
        device_property_id: StrictStr,
        update_device_property0_request: Annotated[UpdateDeviceProperty0Request, Field(description="DeviceProperty attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update_device_property0

        Update DeviceProperty attributes

        :param device_property_id: (required)
        :type device_property_id: str
        :param update_device_property0_request: DeviceProperty attributes (required)
        :type update_device_property0_request: UpdateDeviceProperty0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_device_property0_serialize(
            device_property_id=device_property_id,
            update_device_property0_request=update_device_property0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDeviceProperty0201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_device_property0_serialize(
        self,
        device_property_id,
        update_device_property0_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if device_property_id is not None:
            _path_params['device_property_id'] = device_property_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_device_property0_request is not None:
            _body_params = update_device_property0_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/device-properties/{device_property_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


