# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.models.dynamic_location_actions_dynamic_location_action_id_patch_request import DynamicLocationActionsDynamicLocationActionIdPatchRequest
from openapi_client.models.dynamic_location_actions_get200_response import DynamicLocationActionsGet200Response
from openapi_client.models.dynamic_location_actions_post201_response import DynamicLocationActionsPost201Response
from openapi_client.models.dynamic_location_actions_post_request import DynamicLocationActionsPostRequest

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType


class DynamicLocationActionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def dynamic_location_actions_dynamic_location_action_id_delete(
        self,
        dynamic_location_action_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteConfigurationAttachmentfromconfigurationattachment0200Response:
        """dynamic_location_actions_dynamic_location_action_id_delete


        :param dynamic_location_action_id: (required)
        :type dynamic_location_action_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_dynamic_location_action_id_delete_serialize(
            dynamic_location_action_id=dynamic_location_action_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dynamic_location_actions_dynamic_location_action_id_delete_with_http_info(
        self,
        dynamic_location_action_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteConfigurationAttachmentfromconfigurationattachment0200Response]:
        """dynamic_location_actions_dynamic_location_action_id_delete


        :param dynamic_location_action_id: (required)
        :type dynamic_location_action_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_dynamic_location_action_id_delete_serialize(
            dynamic_location_action_id=dynamic_location_action_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dynamic_location_actions_dynamic_location_action_id_delete_without_preload_content(
        self,
        dynamic_location_action_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dynamic_location_actions_dynamic_location_action_id_delete


        :param dynamic_location_action_id: (required)
        :type dynamic_location_action_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_dynamic_location_action_id_delete_serialize(
            dynamic_location_action_id=dynamic_location_action_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dynamic_location_actions_dynamic_location_action_id_delete_serialize(
        self,
        dynamic_location_action_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if dynamic_location_action_id is not None:
            _path_params['dynamic_location_action_id'] = dynamic_location_action_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/dynamic-location-actions/{dynamic_location_action_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dynamic_location_actions_dynamic_location_action_id_get(
        self,
        dynamic_location_action_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DynamicLocationActionsPost201Response:
        """dynamic_location_actions_dynamic_location_action_id_get


        :param dynamic_location_action_id: (required)
        :type dynamic_location_action_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_dynamic_location_action_id_get_serialize(
            dynamic_location_action_id=dynamic_location_action_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DynamicLocationActionsPost201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dynamic_location_actions_dynamic_location_action_id_get_with_http_info(
        self,
        dynamic_location_action_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DynamicLocationActionsPost201Response]:
        """dynamic_location_actions_dynamic_location_action_id_get


        :param dynamic_location_action_id: (required)
        :type dynamic_location_action_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_dynamic_location_action_id_get_serialize(
            dynamic_location_action_id=dynamic_location_action_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DynamicLocationActionsPost201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dynamic_location_actions_dynamic_location_action_id_get_without_preload_content(
        self,
        dynamic_location_action_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dynamic_location_actions_dynamic_location_action_id_get


        :param dynamic_location_action_id: (required)
        :type dynamic_location_action_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_dynamic_location_action_id_get_serialize(
            dynamic_location_action_id=dynamic_location_action_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DynamicLocationActionsPost201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dynamic_location_actions_dynamic_location_action_id_get_serialize(
        self,
        dynamic_location_action_id,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if dynamic_location_action_id is not None:
            _path_params['dynamic_location_action_id'] = dynamic_location_action_id
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/dynamic-location-actions/{dynamic_location_action_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dynamic_location_actions_dynamic_location_action_id_patch(
        self,
        dynamic_location_action_id: StrictStr,
        dynamic_location_actions_dynamic_location_action_id_patch_request: Annotated[DynamicLocationActionsDynamicLocationActionIdPatchRequest, Field(description="Dynamic location action attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DynamicLocationActionsPost201Response:
        """dynamic_location_actions_dynamic_location_action_id_patch


        :param dynamic_location_action_id: (required)
        :type dynamic_location_action_id: str
        :param dynamic_location_actions_dynamic_location_action_id_patch_request: Dynamic location action attributes (required)
        :type dynamic_location_actions_dynamic_location_action_id_patch_request: DynamicLocationActionsDynamicLocationActionIdPatchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_dynamic_location_action_id_patch_serialize(
            dynamic_location_action_id=dynamic_location_action_id,
            dynamic_location_actions_dynamic_location_action_id_patch_request=dynamic_location_actions_dynamic_location_action_id_patch_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DynamicLocationActionsPost201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dynamic_location_actions_dynamic_location_action_id_patch_with_http_info(
        self,
        dynamic_location_action_id: StrictStr,
        dynamic_location_actions_dynamic_location_action_id_patch_request: Annotated[DynamicLocationActionsDynamicLocationActionIdPatchRequest, Field(description="Dynamic location action attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DynamicLocationActionsPost201Response]:
        """dynamic_location_actions_dynamic_location_action_id_patch


        :param dynamic_location_action_id: (required)
        :type dynamic_location_action_id: str
        :param dynamic_location_actions_dynamic_location_action_id_patch_request: Dynamic location action attributes (required)
        :type dynamic_location_actions_dynamic_location_action_id_patch_request: DynamicLocationActionsDynamicLocationActionIdPatchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_dynamic_location_action_id_patch_serialize(
            dynamic_location_action_id=dynamic_location_action_id,
            dynamic_location_actions_dynamic_location_action_id_patch_request=dynamic_location_actions_dynamic_location_action_id_patch_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DynamicLocationActionsPost201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dynamic_location_actions_dynamic_location_action_id_patch_without_preload_content(
        self,
        dynamic_location_action_id: StrictStr,
        dynamic_location_actions_dynamic_location_action_id_patch_request: Annotated[DynamicLocationActionsDynamicLocationActionIdPatchRequest, Field(description="Dynamic location action attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dynamic_location_actions_dynamic_location_action_id_patch


        :param dynamic_location_action_id: (required)
        :type dynamic_location_action_id: str
        :param dynamic_location_actions_dynamic_location_action_id_patch_request: Dynamic location action attributes (required)
        :type dynamic_location_actions_dynamic_location_action_id_patch_request: DynamicLocationActionsDynamicLocationActionIdPatchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_dynamic_location_action_id_patch_serialize(
            dynamic_location_action_id=dynamic_location_action_id,
            dynamic_location_actions_dynamic_location_action_id_patch_request=dynamic_location_actions_dynamic_location_action_id_patch_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DynamicLocationActionsPost201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dynamic_location_actions_dynamic_location_action_id_patch_serialize(
        self,
        dynamic_location_action_id,
        dynamic_location_actions_dynamic_location_action_id_patch_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if dynamic_location_action_id is not None:
            _path_params['dynamic_location_action_id'] = dynamic_location_action_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dynamic_location_actions_dynamic_location_action_id_patch_request is not None:
            _body_params = dynamic_location_actions_dynamic_location_action_id_patch_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/dynamic-location-actions/{dynamic_location_action_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dynamic_location_actions_get(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_begin_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_begin_description: Optional[StrictStr] = None,
        filter_end_description: Optional[StrictStr] = None,
        filter_label: Optional[StrictStr] = None,
        filter_epsg_code: Optional[StrictStr] = None,
        filter_elevation_datum_name: Optional[StrictStr] = None,
        filter_elevation_datum_uri: Optional[StrictStr] = None,
        filter_configuration_id: Optional[StrictStr] = None,
        filter_x_property_id: Optional[StrictStr] = None,
        filter_y_property_id: Optional[StrictStr] = None,
        filter_z_property_id: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DynamicLocationActionsGet200Response:
        """dynamic_location_actions_get


        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_begin_date:
        :type filter_begin_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_begin_description:
        :type filter_begin_description: str
        :param filter_end_description:
        :type filter_end_description: str
        :param filter_label:
        :type filter_label: str
        :param filter_epsg_code:
        :type filter_epsg_code: str
        :param filter_elevation_datum_name:
        :type filter_elevation_datum_name: str
        :param filter_elevation_datum_uri:
        :type filter_elevation_datum_uri: str
        :param filter_configuration_id:
        :type filter_configuration_id: str
        :param filter_x_property_id:
        :type filter_x_property_id: str
        :param filter_y_property_id:
        :type filter_y_property_id: str
        :param filter_z_property_id:
        :type filter_z_property_id: str
        :param filter: Custom filter
        :type filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_get_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_begin_date=filter_begin_date,
            filter_end_date=filter_end_date,
            filter_begin_description=filter_begin_description,
            filter_end_description=filter_end_description,
            filter_label=filter_label,
            filter_epsg_code=filter_epsg_code,
            filter_elevation_datum_name=filter_elevation_datum_name,
            filter_elevation_datum_uri=filter_elevation_datum_uri,
            filter_configuration_id=filter_configuration_id,
            filter_x_property_id=filter_x_property_id,
            filter_y_property_id=filter_y_property_id,
            filter_z_property_id=filter_z_property_id,
            filter=filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DynamicLocationActionsGet200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dynamic_location_actions_get_with_http_info(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_begin_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_begin_description: Optional[StrictStr] = None,
        filter_end_description: Optional[StrictStr] = None,
        filter_label: Optional[StrictStr] = None,
        filter_epsg_code: Optional[StrictStr] = None,
        filter_elevation_datum_name: Optional[StrictStr] = None,
        filter_elevation_datum_uri: Optional[StrictStr] = None,
        filter_configuration_id: Optional[StrictStr] = None,
        filter_x_property_id: Optional[StrictStr] = None,
        filter_y_property_id: Optional[StrictStr] = None,
        filter_z_property_id: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DynamicLocationActionsGet200Response]:
        """dynamic_location_actions_get


        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_begin_date:
        :type filter_begin_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_begin_description:
        :type filter_begin_description: str
        :param filter_end_description:
        :type filter_end_description: str
        :param filter_label:
        :type filter_label: str
        :param filter_epsg_code:
        :type filter_epsg_code: str
        :param filter_elevation_datum_name:
        :type filter_elevation_datum_name: str
        :param filter_elevation_datum_uri:
        :type filter_elevation_datum_uri: str
        :param filter_configuration_id:
        :type filter_configuration_id: str
        :param filter_x_property_id:
        :type filter_x_property_id: str
        :param filter_y_property_id:
        :type filter_y_property_id: str
        :param filter_z_property_id:
        :type filter_z_property_id: str
        :param filter: Custom filter
        :type filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_get_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_begin_date=filter_begin_date,
            filter_end_date=filter_end_date,
            filter_begin_description=filter_begin_description,
            filter_end_description=filter_end_description,
            filter_label=filter_label,
            filter_epsg_code=filter_epsg_code,
            filter_elevation_datum_name=filter_elevation_datum_name,
            filter_elevation_datum_uri=filter_elevation_datum_uri,
            filter_configuration_id=filter_configuration_id,
            filter_x_property_id=filter_x_property_id,
            filter_y_property_id=filter_y_property_id,
            filter_z_property_id=filter_z_property_id,
            filter=filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DynamicLocationActionsGet200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dynamic_location_actions_get_without_preload_content(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_begin_date: Optional[datetime] = None,
        filter_end_date: Optional[datetime] = None,
        filter_begin_description: Optional[StrictStr] = None,
        filter_end_description: Optional[StrictStr] = None,
        filter_label: Optional[StrictStr] = None,
        filter_epsg_code: Optional[StrictStr] = None,
        filter_elevation_datum_name: Optional[StrictStr] = None,
        filter_elevation_datum_uri: Optional[StrictStr] = None,
        filter_configuration_id: Optional[StrictStr] = None,
        filter_x_property_id: Optional[StrictStr] = None,
        filter_y_property_id: Optional[StrictStr] = None,
        filter_z_property_id: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dynamic_location_actions_get


        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_begin_date:
        :type filter_begin_date: datetime
        :param filter_end_date:
        :type filter_end_date: datetime
        :param filter_begin_description:
        :type filter_begin_description: str
        :param filter_end_description:
        :type filter_end_description: str
        :param filter_label:
        :type filter_label: str
        :param filter_epsg_code:
        :type filter_epsg_code: str
        :param filter_elevation_datum_name:
        :type filter_elevation_datum_name: str
        :param filter_elevation_datum_uri:
        :type filter_elevation_datum_uri: str
        :param filter_configuration_id:
        :type filter_configuration_id: str
        :param filter_x_property_id:
        :type filter_x_property_id: str
        :param filter_y_property_id:
        :type filter_y_property_id: str
        :param filter_z_property_id:
        :type filter_z_property_id: str
        :param filter: Custom filter
        :type filter: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_get_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_begin_date=filter_begin_date,
            filter_end_date=filter_end_date,
            filter_begin_description=filter_begin_description,
            filter_end_description=filter_end_description,
            filter_label=filter_label,
            filter_epsg_code=filter_epsg_code,
            filter_elevation_datum_name=filter_elevation_datum_name,
            filter_elevation_datum_uri=filter_elevation_datum_uri,
            filter_configuration_id=filter_configuration_id,
            filter_x_property_id=filter_x_property_id,
            filter_y_property_id=filter_y_property_id,
            filter_z_property_id=filter_z_property_id,
            filter=filter,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DynamicLocationActionsGet200Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dynamic_location_actions_get_serialize(
        self,
        include,
        page_number,
        page_size,
        sort,
        filter_id,
        filter_begin_date,
        filter_end_date,
        filter_begin_description,
        filter_end_description,
        filter_label,
        filter_epsg_code,
        filter_elevation_datum_name,
        filter_elevation_datum_uri,
        filter_configuration_id,
        filter_x_property_id,
        filter_y_property_id,
        filter_z_property_id,
        filter,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        if page_number is not None:
            
            _query_params.append(('page[number]', page_number))
            
        if page_size is not None:
            
            _query_params.append(('page[size]', page_size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if filter_id is not None:
            
            _query_params.append(('filter[id]', filter_id))
            
        if filter_begin_date is not None:
            if isinstance(filter_begin_date, datetime):
                _query_params.append(
                    (
                        'filter[begin_date]',
                        filter_begin_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[begin_date]', filter_begin_date))
            
        if filter_end_date is not None:
            if isinstance(filter_end_date, datetime):
                _query_params.append(
                    (
                        'filter[end_date]',
                        filter_end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[end_date]', filter_end_date))
            
        if filter_begin_description is not None:
            
            _query_params.append(('filter[begin_description]', filter_begin_description))
            
        if filter_end_description is not None:
            
            _query_params.append(('filter[end_description]', filter_end_description))
            
        if filter_label is not None:
            
            _query_params.append(('filter[label]', filter_label))
            
        if filter_epsg_code is not None:
            
            _query_params.append(('filter[epsg_code]', filter_epsg_code))
            
        if filter_elevation_datum_name is not None:
            
            _query_params.append(('filter[elevation_datum_name]', filter_elevation_datum_name))
            
        if filter_elevation_datum_uri is not None:
            
            _query_params.append(('filter[elevation_datum_uri]', filter_elevation_datum_uri))
            
        if filter_configuration_id is not None:
            
            _query_params.append(('filter[configuration_id]', filter_configuration_id))
            
        if filter_x_property_id is not None:
            
            _query_params.append(('filter[x_property_id]', filter_x_property_id))
            
        if filter_y_property_id is not None:
            
            _query_params.append(('filter[y_property_id]', filter_y_property_id))
            
        if filter_z_property_id is not None:
            
            _query_params.append(('filter[z_property_id]', filter_z_property_id))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api.json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/dynamic-location-actions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dynamic_location_actions_post(
        self,
        dynamic_location_actions_post_request: DynamicLocationActionsPostRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DynamicLocationActionsPost201Response:
        """dynamic_location_actions_post


        :param dynamic_location_actions_post_request: (required)
        :type dynamic_location_actions_post_request: DynamicLocationActionsPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_post_serialize(
            dynamic_location_actions_post_request=dynamic_location_actions_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DynamicLocationActionsPost201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dynamic_location_actions_post_with_http_info(
        self,
        dynamic_location_actions_post_request: DynamicLocationActionsPostRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DynamicLocationActionsPost201Response]:
        """dynamic_location_actions_post


        :param dynamic_location_actions_post_request: (required)
        :type dynamic_location_actions_post_request: DynamicLocationActionsPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_post_serialize(
            dynamic_location_actions_post_request=dynamic_location_actions_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DynamicLocationActionsPost201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dynamic_location_actions_post_without_preload_content(
        self,
        dynamic_location_actions_post_request: DynamicLocationActionsPostRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dynamic_location_actions_post


        :param dynamic_location_actions_post_request: (required)
        :type dynamic_location_actions_post_request: DynamicLocationActionsPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dynamic_location_actions_post_serialize(
            dynamic_location_actions_post_request=dynamic_location_actions_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DynamicLocationActionsPost201Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dynamic_location_actions_post_serialize(
        self,
        dynamic_location_actions_post_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dynamic_location_actions_post_request is not None:
            _body_params = dynamic_location_actions_post_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api.json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/dynamic-location-actions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


