# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from openapi_client.models.create_platform0201_response import CreatePlatform0201Response
from openapi_client.models.create_platform0_request import CreatePlatform0Request
from openapi_client.models.delete_configuration_attachmentfromconfigurationattachment0200_response import DeleteConfigurationAttachmentfromconfigurationattachment0200Response
from openapi_client.models.retrieveacollectionof_platformobjects0200_response import RetrieveacollectionofPlatformobjects0200Response
from openapi_client.models.update_platform0_request import UpdatePlatform0Request

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType


class PlatformsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def archive_platform(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """archive_platform

        Archive a platform.

        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._archive_platform_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
            '409': "Conflict",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def archive_platform_with_http_info(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """archive_platform

        Archive a platform.

        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._archive_platform_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
            '409': "Conflict",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def archive_platform_without_preload_content(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """archive_platform

        Archive a platform.

        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._archive_platform_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
            '409': "Conflict",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _archive_platform_serialize(
        self,
        platform_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if platform_id is not None:
            _path_params['platform_id'] = platform_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/platforms/{platform_id}/archive',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_platform0(
        self,
        create_platform0_request: CreatePlatform0Request,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePlatform0201Response:
        """create_platform0


        :param create_platform0_request: (required)
        :type create_platform0_request: CreatePlatform0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_platform0_serialize(
            create_platform0_request=create_platform0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreatePlatform0201Response",
            '401': "AuthentificationRequired",
            '409': "Conflict",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_platform0_with_http_info(
        self,
        create_platform0_request: CreatePlatform0Request,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePlatform0201Response]:
        """create_platform0


        :param create_platform0_request: (required)
        :type create_platform0_request: CreatePlatform0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_platform0_serialize(
            create_platform0_request=create_platform0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreatePlatform0201Response",
            '401': "AuthentificationRequired",
            '409': "Conflict",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_platform0_without_preload_content(
        self,
        create_platform0_request: CreatePlatform0Request,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """create_platform0


        :param create_platform0_request: (required)
        :type create_platform0_request: CreatePlatform0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_platform0_serialize(
            create_platform0_request=create_platform0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreatePlatform0201Response",
            '401': "AuthentificationRequired",
            '409': "Conflict",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_platform0_serialize(
        self,
        create_platform0_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_platform0_request is not None:
            _body_params = create_platform0_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/platforms',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_platformfromplatform3(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteConfigurationAttachmentfromconfigurationattachment0200Response:
        """delete_platformfromplatform3


        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_platformfromplatform3_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
            '401': "AuthentificationRequired",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_platformfromplatform3_with_http_info(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteConfigurationAttachmentfromconfigurationattachment0200Response]:
        """delete_platformfromplatform3


        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_platformfromplatform3_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
            '401': "AuthentificationRequired",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_platformfromplatform3_without_preload_content(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """delete_platformfromplatform3


        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_platformfromplatform3_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteConfigurationAttachmentfromconfigurationattachment0200Response",
            '401': "AuthentificationRequired",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_platformfromplatform3_serialize(
        self,
        platform_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if platform_id is not None:
            _path_params['platform_id'] = platform_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/platforms/{platform_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def restore_platform(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """restore_platform

        Restore an archived platform.

        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._restore_platform_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def restore_platform_with_http_info(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """restore_platform

        Restore an archived platform.

        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._restore_platform_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def restore_platform_without_preload_content(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """restore_platform

        Restore an archived platform.

        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._restore_platform_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "AuthentificationRequired",
            '403': "ArchiveConfiguration403Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _restore_platform_serialize(
        self,
        platform_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if platform_id is not None:
            _path_params['platform_id'] = platform_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/platforms/{platform_id}/restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieve_platform_sensor_ml(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """retrieve_platform_sensor_ml

        Retrieve Platform sensorML

        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_platform_sensor_ml_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "AuthentificationRequired",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieve_platform_sensor_ml_with_http_info(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """retrieve_platform_sensor_ml

        Retrieve Platform sensorML

        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_platform_sensor_ml_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "AuthentificationRequired",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieve_platform_sensor_ml_without_preload_content(
        self,
        platform_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieve_platform_sensor_ml

        Retrieve Platform sensorML

        :param platform_id: (required)
        :type platform_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_platform_sensor_ml_serialize(
            platform_id=platform_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "AuthentificationRequired",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieve_platform_sensor_ml_serialize(
        self,
        platform_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if platform_id is not None:
            _path_params['platform_id'] = platform_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/platforms/{platform_id}/sensorml',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieve_platforminstance0(
        self,
        platform_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePlatform0201Response:
        """retrieve_platforminstance0

        Retrieve Platform from platform

        :param platform_id: (required)
        :type platform_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_platforminstance0_serialize(
            platform_id=platform_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePlatform0201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieve_platforminstance0_with_http_info(
        self,
        platform_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePlatform0201Response]:
        """retrieve_platforminstance0

        Retrieve Platform from platform

        :param platform_id: (required)
        :type platform_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_platforminstance0_serialize(
            platform_id=platform_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePlatform0201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieve_platforminstance0_without_preload_content(
        self,
        platform_id: StrictStr,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieve_platforminstance0

        Retrieve Platform from platform

        :param platform_id: (required)
        :type platform_id: str
        :param include: Relationships to include.
        :type include: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_platforminstance0_serialize(
            platform_id=platform_id,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePlatform0201Response",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieve_platforminstance0_serialize(
        self,
        platform_id,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if platform_id is not None:
            _path_params['platform_id'] = platform_id
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/platforms/{platform_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def retrieveacollectionof_platformobjects0(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_short_name: Optional[StrictStr] = None,
        filter_long_name: Optional[StrictStr] = None,
        filter_manufacturer_uri: Optional[StrictStr] = None,
        filter_manufacturer_name: Optional[StrictStr] = None,
        filter_model: Optional[StrictStr] = None,
        filter_platform_type_uri: Optional[StrictStr] = None,
        filter_platform_type_name: Optional[StrictStr] = None,
        filter_status_uri: Optional[StrictStr] = None,
        filter_status_name: Optional[StrictStr] = None,
        filter_website: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_is_private: Optional[StrictBool] = None,
        filter_is_internal: Optional[StrictBool] = None,
        filter_is_public: Optional[StrictBool] = None,
        filter_archived: Optional[StrictBool] = None,
        filter_update_description: Optional[StrictStr] = None,
        filter_country: Optional[StrictStr] = None,
        filter_inventory_number: Optional[StrictStr] = None,
        filter_serial_number: Optional[StrictStr] = None,
        filter_persistent_identifier: Optional[StrictStr] = None,
        filter_schema_version: Optional[StrictStr] = None,
        filter_identifier_type: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        hide_archived: Annotated[Optional[StrictBool], Field(description="In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RetrieveacollectionofPlatformobjects0200Response:
        """retrieveacollectionof_platformobjects0

        Retrieve Platform

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_description:
        :type filter_description: str
        :param filter_short_name:
        :type filter_short_name: str
        :param filter_long_name:
        :type filter_long_name: str
        :param filter_manufacturer_uri:
        :type filter_manufacturer_uri: str
        :param filter_manufacturer_name:
        :type filter_manufacturer_name: str
        :param filter_model:
        :type filter_model: str
        :param filter_platform_type_uri:
        :type filter_platform_type_uri: str
        :param filter_platform_type_name:
        :type filter_platform_type_name: str
        :param filter_status_uri:
        :type filter_status_uri: str
        :param filter_status_name:
        :type filter_status_name: str
        :param filter_website:
        :type filter_website: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_is_private:
        :type filter_is_private: bool
        :param filter_is_internal:
        :type filter_is_internal: bool
        :param filter_is_public:
        :type filter_is_public: bool
        :param filter_archived:
        :type filter_archived: bool
        :param filter_update_description:
        :type filter_update_description: str
        :param filter_country:
        :type filter_country: str
        :param filter_inventory_number:
        :type filter_inventory_number: str
        :param filter_serial_number:
        :type filter_serial_number: str
        :param filter_persistent_identifier:
        :type filter_persistent_identifier: str
        :param filter_schema_version:
        :type filter_schema_version: str
        :param filter_identifier_type:
        :type filter_identifier_type: str
        :param filter: Custom filter
        :type filter: str
        :param hide_archived: In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.
        :type hide_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_platformobjects0_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_description=filter_description,
            filter_short_name=filter_short_name,
            filter_long_name=filter_long_name,
            filter_manufacturer_uri=filter_manufacturer_uri,
            filter_manufacturer_name=filter_manufacturer_name,
            filter_model=filter_model,
            filter_platform_type_uri=filter_platform_type_uri,
            filter_platform_type_name=filter_platform_type_name,
            filter_status_uri=filter_status_uri,
            filter_status_name=filter_status_name,
            filter_website=filter_website,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_is_private=filter_is_private,
            filter_is_internal=filter_is_internal,
            filter_is_public=filter_is_public,
            filter_archived=filter_archived,
            filter_update_description=filter_update_description,
            filter_country=filter_country,
            filter_inventory_number=filter_inventory_number,
            filter_serial_number=filter_serial_number,
            filter_persistent_identifier=filter_persistent_identifier,
            filter_schema_version=filter_schema_version,
            filter_identifier_type=filter_identifier_type,
            filter=filter,
            hide_archived=hide_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofPlatformobjects0200Response",
            '400': "InvalidFilters",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def retrieveacollectionof_platformobjects0_with_http_info(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_short_name: Optional[StrictStr] = None,
        filter_long_name: Optional[StrictStr] = None,
        filter_manufacturer_uri: Optional[StrictStr] = None,
        filter_manufacturer_name: Optional[StrictStr] = None,
        filter_model: Optional[StrictStr] = None,
        filter_platform_type_uri: Optional[StrictStr] = None,
        filter_platform_type_name: Optional[StrictStr] = None,
        filter_status_uri: Optional[StrictStr] = None,
        filter_status_name: Optional[StrictStr] = None,
        filter_website: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_is_private: Optional[StrictBool] = None,
        filter_is_internal: Optional[StrictBool] = None,
        filter_is_public: Optional[StrictBool] = None,
        filter_archived: Optional[StrictBool] = None,
        filter_update_description: Optional[StrictStr] = None,
        filter_country: Optional[StrictStr] = None,
        filter_inventory_number: Optional[StrictStr] = None,
        filter_serial_number: Optional[StrictStr] = None,
        filter_persistent_identifier: Optional[StrictStr] = None,
        filter_schema_version: Optional[StrictStr] = None,
        filter_identifier_type: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        hide_archived: Annotated[Optional[StrictBool], Field(description="In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RetrieveacollectionofPlatformobjects0200Response]:
        """retrieveacollectionof_platformobjects0

        Retrieve Platform

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_description:
        :type filter_description: str
        :param filter_short_name:
        :type filter_short_name: str
        :param filter_long_name:
        :type filter_long_name: str
        :param filter_manufacturer_uri:
        :type filter_manufacturer_uri: str
        :param filter_manufacturer_name:
        :type filter_manufacturer_name: str
        :param filter_model:
        :type filter_model: str
        :param filter_platform_type_uri:
        :type filter_platform_type_uri: str
        :param filter_platform_type_name:
        :type filter_platform_type_name: str
        :param filter_status_uri:
        :type filter_status_uri: str
        :param filter_status_name:
        :type filter_status_name: str
        :param filter_website:
        :type filter_website: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_is_private:
        :type filter_is_private: bool
        :param filter_is_internal:
        :type filter_is_internal: bool
        :param filter_is_public:
        :type filter_is_public: bool
        :param filter_archived:
        :type filter_archived: bool
        :param filter_update_description:
        :type filter_update_description: str
        :param filter_country:
        :type filter_country: str
        :param filter_inventory_number:
        :type filter_inventory_number: str
        :param filter_serial_number:
        :type filter_serial_number: str
        :param filter_persistent_identifier:
        :type filter_persistent_identifier: str
        :param filter_schema_version:
        :type filter_schema_version: str
        :param filter_identifier_type:
        :type filter_identifier_type: str
        :param filter: Custom filter
        :type filter: str
        :param hide_archived: In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.
        :type hide_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_platformobjects0_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_description=filter_description,
            filter_short_name=filter_short_name,
            filter_long_name=filter_long_name,
            filter_manufacturer_uri=filter_manufacturer_uri,
            filter_manufacturer_name=filter_manufacturer_name,
            filter_model=filter_model,
            filter_platform_type_uri=filter_platform_type_uri,
            filter_platform_type_name=filter_platform_type_name,
            filter_status_uri=filter_status_uri,
            filter_status_name=filter_status_name,
            filter_website=filter_website,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_is_private=filter_is_private,
            filter_is_internal=filter_is_internal,
            filter_is_public=filter_is_public,
            filter_archived=filter_archived,
            filter_update_description=filter_update_description,
            filter_country=filter_country,
            filter_inventory_number=filter_inventory_number,
            filter_serial_number=filter_serial_number,
            filter_persistent_identifier=filter_persistent_identifier,
            filter_schema_version=filter_schema_version,
            filter_identifier_type=filter_identifier_type,
            filter=filter,
            hide_archived=hide_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofPlatformobjects0200Response",
            '400': "InvalidFilters",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def retrieveacollectionof_platformobjects0_without_preload_content(
        self,
        include: Annotated[Optional[StrictStr], Field(description="Relationships to include.")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to query")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Max number of items")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order")] = None,
        filter_id: Optional[StrictStr] = None,
        filter_description: Optional[StrictStr] = None,
        filter_short_name: Optional[StrictStr] = None,
        filter_long_name: Optional[StrictStr] = None,
        filter_manufacturer_uri: Optional[StrictStr] = None,
        filter_manufacturer_name: Optional[StrictStr] = None,
        filter_model: Optional[StrictStr] = None,
        filter_platform_type_uri: Optional[StrictStr] = None,
        filter_platform_type_name: Optional[StrictStr] = None,
        filter_status_uri: Optional[StrictStr] = None,
        filter_status_name: Optional[StrictStr] = None,
        filter_website: Optional[StrictStr] = None,
        filter_created_at: Optional[datetime] = None,
        filter_updated_at: Optional[datetime] = None,
        filter_is_private: Optional[StrictBool] = None,
        filter_is_internal: Optional[StrictBool] = None,
        filter_is_public: Optional[StrictBool] = None,
        filter_archived: Optional[StrictBool] = None,
        filter_update_description: Optional[StrictStr] = None,
        filter_country: Optional[StrictStr] = None,
        filter_inventory_number: Optional[StrictStr] = None,
        filter_serial_number: Optional[StrictStr] = None,
        filter_persistent_identifier: Optional[StrictStr] = None,
        filter_schema_version: Optional[StrictStr] = None,
        filter_identifier_type: Optional[StrictStr] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Custom filter")] = None,
        hide_archived: Annotated[Optional[StrictBool], Field(description="In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """retrieveacollectionof_platformobjects0

        Retrieve Platform

        :param include: Relationships to include.
        :type include: str
        :param page_number: Page number to query
        :type page_number: int
        :param page_size: Max number of items
        :type page_size: int
        :param sort: Sort order
        :type sort: str
        :param filter_id:
        :type filter_id: str
        :param filter_description:
        :type filter_description: str
        :param filter_short_name:
        :type filter_short_name: str
        :param filter_long_name:
        :type filter_long_name: str
        :param filter_manufacturer_uri:
        :type filter_manufacturer_uri: str
        :param filter_manufacturer_name:
        :type filter_manufacturer_name: str
        :param filter_model:
        :type filter_model: str
        :param filter_platform_type_uri:
        :type filter_platform_type_uri: str
        :param filter_platform_type_name:
        :type filter_platform_type_name: str
        :param filter_status_uri:
        :type filter_status_uri: str
        :param filter_status_name:
        :type filter_status_name: str
        :param filter_website:
        :type filter_website: str
        :param filter_created_at:
        :type filter_created_at: datetime
        :param filter_updated_at:
        :type filter_updated_at: datetime
        :param filter_is_private:
        :type filter_is_private: bool
        :param filter_is_internal:
        :type filter_is_internal: bool
        :param filter_is_public:
        :type filter_is_public: bool
        :param filter_archived:
        :type filter_archived: bool
        :param filter_update_description:
        :type filter_update_description: str
        :param filter_country:
        :type filter_country: str
        :param filter_inventory_number:
        :type filter_inventory_number: str
        :param filter_serial_number:
        :type filter_serial_number: str
        :param filter_persistent_identifier:
        :type filter_persistent_identifier: str
        :param filter_schema_version:
        :type filter_schema_version: str
        :param filter_identifier_type:
        :type filter_identifier_type: str
        :param filter: Custom filter
        :type filter: str
        :param hide_archived: In general we hide archived objects. With this parameter those can be shown in the list search together with the non archived ones.
        :type hide_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieveacollectionof_platformobjects0_serialize(
            include=include,
            page_number=page_number,
            page_size=page_size,
            sort=sort,
            filter_id=filter_id,
            filter_description=filter_description,
            filter_short_name=filter_short_name,
            filter_long_name=filter_long_name,
            filter_manufacturer_uri=filter_manufacturer_uri,
            filter_manufacturer_name=filter_manufacturer_name,
            filter_model=filter_model,
            filter_platform_type_uri=filter_platform_type_uri,
            filter_platform_type_name=filter_platform_type_name,
            filter_status_uri=filter_status_uri,
            filter_status_name=filter_status_name,
            filter_website=filter_website,
            filter_created_at=filter_created_at,
            filter_updated_at=filter_updated_at,
            filter_is_private=filter_is_private,
            filter_is_internal=filter_is_internal,
            filter_is_public=filter_is_public,
            filter_archived=filter_archived,
            filter_update_description=filter_update_description,
            filter_country=filter_country,
            filter_inventory_number=filter_inventory_number,
            filter_serial_number=filter_serial_number,
            filter_persistent_identifier=filter_persistent_identifier,
            filter_schema_version=filter_schema_version,
            filter_identifier_type=filter_identifier_type,
            filter=filter,
            hide_archived=hide_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieveacollectionofPlatformobjects0200Response",
            '400': "InvalidFilters",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieveacollectionof_platformobjects0_serialize(
        self,
        include,
        page_number,
        page_size,
        sort,
        filter_id,
        filter_description,
        filter_short_name,
        filter_long_name,
        filter_manufacturer_uri,
        filter_manufacturer_name,
        filter_model,
        filter_platform_type_uri,
        filter_platform_type_name,
        filter_status_uri,
        filter_status_name,
        filter_website,
        filter_created_at,
        filter_updated_at,
        filter_is_private,
        filter_is_internal,
        filter_is_public,
        filter_archived,
        filter_update_description,
        filter_country,
        filter_inventory_number,
        filter_serial_number,
        filter_persistent_identifier,
        filter_schema_version,
        filter_identifier_type,
        filter,
        hide_archived,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include is not None:
            
            _query_params.append(('include', include))
            
        if page_number is not None:
            
            _query_params.append(('page[number]', page_number))
            
        if page_size is not None:
            
            _query_params.append(('page[size]', page_size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if filter_id is not None:
            
            _query_params.append(('filter[id]', filter_id))
            
        if filter_description is not None:
            
            _query_params.append(('filter[description]', filter_description))
            
        if filter_short_name is not None:
            
            _query_params.append(('filter[short_name]', filter_short_name))
            
        if filter_long_name is not None:
            
            _query_params.append(('filter[long_name]', filter_long_name))
            
        if filter_manufacturer_uri is not None:
            
            _query_params.append(('filter[manufacturer_uri]', filter_manufacturer_uri))
            
        if filter_manufacturer_name is not None:
            
            _query_params.append(('filter[manufacturer_name]', filter_manufacturer_name))
            
        if filter_model is not None:
            
            _query_params.append(('filter[model]', filter_model))
            
        if filter_platform_type_uri is not None:
            
            _query_params.append(('filter[platform_type_uri]', filter_platform_type_uri))
            
        if filter_platform_type_name is not None:
            
            _query_params.append(('filter[platform_type_name]', filter_platform_type_name))
            
        if filter_status_uri is not None:
            
            _query_params.append(('filter[status_uri]', filter_status_uri))
            
        if filter_status_name is not None:
            
            _query_params.append(('filter[status_name]', filter_status_name))
            
        if filter_website is not None:
            
            _query_params.append(('filter[website]', filter_website))
            
        if filter_created_at is not None:
            if isinstance(filter_created_at, datetime):
                _query_params.append(
                    (
                        'filter[created_at]',
                        filter_created_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[created_at]', filter_created_at))
            
        if filter_updated_at is not None:
            if isinstance(filter_updated_at, datetime):
                _query_params.append(
                    (
                        'filter[updated_at]',
                        filter_updated_at.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter[updated_at]', filter_updated_at))
            
        if filter_is_private is not None:
            
            _query_params.append(('filter[is_private]', filter_is_private))
            
        if filter_is_internal is not None:
            
            _query_params.append(('filter[is_internal]', filter_is_internal))
            
        if filter_is_public is not None:
            
            _query_params.append(('filter[is_public]', filter_is_public))
            
        if filter_archived is not None:
            
            _query_params.append(('filter[archived]', filter_archived))
            
        if filter_update_description is not None:
            
            _query_params.append(('filter[update_description]', filter_update_description))
            
        if filter_country is not None:
            
            _query_params.append(('filter[country]', filter_country))
            
        if filter_inventory_number is not None:
            
            _query_params.append(('filter[inventory_number]', filter_inventory_number))
            
        if filter_serial_number is not None:
            
            _query_params.append(('filter[serial_number]', filter_serial_number))
            
        if filter_persistent_identifier is not None:
            
            _query_params.append(('filter[persistent_identifier]', filter_persistent_identifier))
            
        if filter_schema_version is not None:
            
            _query_params.append(('filter[schema_version]', filter_schema_version))
            
        if filter_identifier_type is not None:
            
            _query_params.append(('filter[identifier_type]', filter_identifier_type))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if hide_archived is not None:
            
            _query_params.append(('hide_archived', hide_archived))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/platforms',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_platform0(
        self,
        platform_id: StrictStr,
        update_platform0_request: Annotated[UpdatePlatform0Request, Field(description="Platform attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePlatform0201Response:
        """update_platform0

        Update Platform attributes

        :param platform_id: (required)
        :type platform_id: str
        :param update_platform0_request: Platform attributes (required)
        :type update_platform0_request: UpdatePlatform0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_platform0_serialize(
            platform_id=platform_id,
            update_platform0_request=update_platform0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePlatform0201Response",
            '401': "AuthentificationRequired",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_platform0_with_http_info(
        self,
        platform_id: StrictStr,
        update_platform0_request: Annotated[UpdatePlatform0Request, Field(description="Platform attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePlatform0201Response]:
        """update_platform0

        Update Platform attributes

        :param platform_id: (required)
        :type platform_id: str
        :param update_platform0_request: Platform attributes (required)
        :type update_platform0_request: UpdatePlatform0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_platform0_serialize(
            platform_id=platform_id,
            update_platform0_request=update_platform0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePlatform0201Response",
            '401': "AuthentificationRequired",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_platform0_without_preload_content(
        self,
        platform_id: StrictStr,
        update_platform0_request: Annotated[UpdatePlatform0Request, Field(description="Platform attributes")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update_platform0

        Update Platform attributes

        :param platform_id: (required)
        :type platform_id: str
        :param update_platform0_request: Platform attributes (required)
        :type update_platform0_request: UpdatePlatform0Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_platform0_serialize(
            platform_id=platform_id,
            update_platform0_request=update_platform0_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePlatform0201Response",
            '401': "AuthentificationRequired",
            '404': "ConfigurationAttachmentsConfigurationAttachmentIdFileFilenameGet404Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_platform0_serialize(
        self,
        platform_id,
        update_platform0_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if platform_id is not None:
            _path_params['platform_id'] = platform_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_platform0_request is not None:
            _body_params = update_platform0_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.api+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/platforms/{platform_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


