# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateConfiguration0RequestDataAttributes(BaseModel):
    """
    CreateConfiguration0RequestDataAttributes
    """ # noqa: E501
    start_date: Optional[datetime] = None
    end_date: Optional[datetime] = None
    label: Optional[StrictStr] = None
    project: Optional[StrictStr] = None
    campaign: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    cfg_permission_group: StrictStr
    is_internal: Optional[StrictBool] = None
    is_public: Optional[StrictBool] = None
    keywords: Optional[List[StrictStr]] = None
    persistent_identifier: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["start_date", "end_date", "label", "project", "campaign", "description", "status", "cfg_permission_group", "is_internal", "is_public", "keywords", "persistent_identifier"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateConfiguration0RequestDataAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateConfiguration0RequestDataAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "start_date": obj.get("start_date"),
            "end_date": obj.get("end_date"),
            "label": obj.get("label"),
            "project": obj.get("project"),
            "campaign": obj.get("campaign"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "cfg_permission_group": obj.get("cfg_permission_group"),
            "is_internal": obj.get("is_internal"),
            "is_public": obj.get("is_public"),
            "keywords": obj.get("keywords"),
            "persistent_identifier": obj.get("persistent_identifier")
        })
        return _obj


