# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CreateSite0RequestDataAttributes(BaseModel):
    """
    CreateSite0RequestDataAttributes
    """ # noqa: E501
    persistent_identifier: Optional[StrictStr] = None
    label: Optional[StrictStr] = None
    geometry: Optional[List[StrictStr]] = None
    description: Optional[StrictStr] = None
    epsg_code: Optional[StrictStr] = None
    is_internal: Optional[StrictBool] = None
    is_public: Optional[StrictBool] = None
    group_ids: Optional[List[StrictStr]] = None
    street: Optional[StrictStr] = None
    street_number: Optional[StrictStr] = None
    city: Optional[StrictStr] = None
    zip_code: Optional[StrictStr] = None
    country: Optional[StrictStr] = None
    building: Optional[StrictStr] = None
    room: Optional[StrictStr] = None
    site_type_uri: Optional[StrictStr] = None
    site_type_name: Optional[StrictStr] = None
    site_usage_uri: Optional[StrictStr] = None
    site_usage_name: Optional[StrictStr] = None
    elevation: Optional[Union[StrictFloat, StrictInt]] = None
    elevation_datum_name: Optional[StrictStr] = None
    elevation_datum_uri: Optional[StrictStr] = None
    website: Optional[StrictStr] = None
    keywords: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["persistent_identifier", "label", "geometry", "description", "epsg_code", "is_internal", "is_public", "group_ids", "street", "street_number", "city", "zip_code", "country", "building", "room", "site_type_uri", "site_type_name", "site_usage_uri", "site_usage_name", "elevation", "elevation_datum_name", "elevation_datum_uri", "website", "keywords"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSite0RequestDataAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSite0RequestDataAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "persistent_identifier": obj.get("persistent_identifier"),
            "label": obj.get("label"),
            "geometry": obj.get("geometry"),
            "description": obj.get("description"),
            "epsg_code": obj.get("epsg_code"),
            "is_internal": obj.get("is_internal"),
            "is_public": obj.get("is_public"),
            "group_ids": obj.get("group_ids"),
            "street": obj.get("street"),
            "street_number": obj.get("street_number"),
            "city": obj.get("city"),
            "zip_code": obj.get("zip_code"),
            "country": obj.get("country"),
            "building": obj.get("building"),
            "room": obj.get("room"),
            "site_type_uri": obj.get("site_type_uri"),
            "site_type_name": obj.get("site_type_name"),
            "site_usage_uri": obj.get("site_usage_uri"),
            "site_usage_name": obj.get("site_usage_name"),
            "elevation": obj.get("elevation"),
            "elevation_datum_name": obj.get("elevation_datum_name"),
            "elevation_datum_uri": obj.get("elevation_datum_uri"),
            "website": obj.get("website"),
            "keywords": obj.get("keywords")
        })
        return _obj


