# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DeviceMountActionsDeviceMountActionIdPatchRequestDataAttributes(BaseModel):
    """
    DeviceMountActionsDeviceMountActionIdPatchRequestDataAttributes
    """ # noqa: E501
    begin_date: Optional[datetime] = None
    end_date: Optional[datetime] = None
    begin_description: Optional[StrictStr] = None
    end_description: Optional[StrictStr] = None
    offset_x: Optional[Union[StrictFloat, StrictInt]] = None
    offset_y: Optional[Union[StrictFloat, StrictInt]] = None
    offset_z: Optional[Union[StrictFloat, StrictInt]] = None
    x: Optional[Union[StrictFloat, StrictInt]] = None
    y: Optional[Union[StrictFloat, StrictInt]] = None
    z: Optional[Union[StrictFloat, StrictInt]] = None
    epsg_code: Optional[StrictStr] = None
    elevation_datum_name: Optional[StrictStr] = None
    elevation_datum_uri: Optional[StrictStr] = None
    label: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["begin_date", "end_date", "begin_description", "end_description", "offset_x", "offset_y", "offset_z", "x", "y", "z", "epsg_code", "elevation_datum_name", "elevation_datum_uri", "label"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceMountActionsDeviceMountActionIdPatchRequestDataAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceMountActionsDeviceMountActionIdPatchRequestDataAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "begin_date": obj.get("begin_date"),
            "end_date": obj.get("end_date"),
            "begin_description": obj.get("begin_description"),
            "end_description": obj.get("end_description"),
            "offset_x": obj.get("offset_x"),
            "offset_y": obj.get("offset_y"),
            "offset_z": obj.get("offset_z"),
            "x": obj.get("x"),
            "y": obj.get("y"),
            "z": obj.get("z"),
            "epsg_code": obj.get("epsg_code"),
            "elevation_datum_name": obj.get("elevation_datum_name"),
            "elevation_datum_uri": obj.get("elevation_datum_uri"),
            "label": obj.get("label")
        })
        return _obj


