# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.configuration_contact_roles_get200_response_data_inner_relationships_contact import ConfigurationContactRolesGet200ResponseDataInnerRelationshipsContact
from openapi_client.models.device_mount_actions_get200_response_data_inner_relationships_parent_platform import DeviceMountActionsGet200ResponseDataInnerRelationshipsParentPlatform
from openapi_client.models.retrieveacollectionof_configuration_attachmentobjects0200_response_data_inner_relationships_configuration import RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfiguration
from openapi_client.models.retrieveacollectionof_custom_fieldobjects0200_response_data_inner_relationships_device import RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationshipsDevice
from typing import Optional, Set
from typing_extensions import Self

class DeviceMountActionsPostRequestDataRelationships(BaseModel):
    """
    DeviceMountActionsPostRequestDataRelationships
    """ # noqa: E501
    device: Optional[RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationshipsDevice] = None
    parent_platform: Optional[DeviceMountActionsGet200ResponseDataInnerRelationshipsParentPlatform] = None
    parent_device: Optional[RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationshipsDevice] = None
    configuration: Optional[RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfiguration] = None
    begin_contact: Optional[ConfigurationContactRolesGet200ResponseDataInnerRelationshipsContact] = None
    end_contact: Optional[ConfigurationContactRolesGet200ResponseDataInnerRelationshipsContact] = None
    __properties: ClassVar[List[str]] = ["device", "parent_platform", "parent_device", "configuration", "begin_contact", "end_contact"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceMountActionsPostRequestDataRelationships from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of device
        if self.device:
            _dict['device'] = self.device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent_platform
        if self.parent_platform:
            _dict['parent_platform'] = self.parent_platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent_device
        if self.parent_device:
            _dict['parent_device'] = self.parent_device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of configuration
        if self.configuration:
            _dict['configuration'] = self.configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of begin_contact
        if self.begin_contact:
            _dict['begin_contact'] = self.begin_contact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of end_contact
        if self.end_contact:
            _dict['end_contact'] = self.end_contact.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceMountActionsPostRequestDataRelationships from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "device": RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationshipsDevice.from_dict(obj["device"]) if obj.get("device") is not None else None,
            "parent_platform": DeviceMountActionsGet200ResponseDataInnerRelationshipsParentPlatform.from_dict(obj["parent_platform"]) if obj.get("parent_platform") is not None else None,
            "parent_device": RetrieveacollectionofCustomFieldobjects0200ResponseDataInnerRelationshipsDevice.from_dict(obj["parent_device"]) if obj.get("parent_device") is not None else None,
            "configuration": RetrieveacollectionofConfigurationAttachmentobjects0200ResponseDataInnerRelationshipsConfiguration.from_dict(obj["configuration"]) if obj.get("configuration") is not None else None,
            "begin_contact": ConfigurationContactRolesGet200ResponseDataInnerRelationshipsContact.from_dict(obj["begin_contact"]) if obj.get("begin_contact") is not None else None,
            "end_contact": ConfigurationContactRolesGet200ResponseDataInnerRelationshipsContact.from_dict(obj["end_contact"]) if obj.get("end_contact") is not None else None
        })
        return _obj


