# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class RetrieveacollectionofDevicePropertyobjects0200ResponseDataInnerAttributes(BaseModel):
    """
    RetrieveacollectionofDevicePropertyobjects0200ResponseDataInnerAttributes
    """ # noqa: E501
    measuring_range_min: Optional[Union[StrictFloat, StrictInt]] = None
    measuring_range_max: Optional[Union[StrictFloat, StrictInt]] = None
    failure_value: Optional[Union[StrictFloat, StrictInt]] = None
    accuracy: Optional[Union[StrictFloat, StrictInt]] = None
    label: Optional[StrictStr] = None
    accuracy_unit_uri: Optional[StrictStr] = None
    accuracy_unit_name: Optional[StrictStr] = None
    unit_uri: Optional[StrictStr] = None
    unit_name: Optional[StrictStr] = None
    compartment_uri: Optional[StrictStr] = None
    compartment_name: Optional[StrictStr] = None
    property_uri: Optional[StrictStr] = None
    property_name: Optional[StrictStr] = None
    sampling_media_uri: Optional[StrictStr] = None
    sampling_media_name: Optional[StrictStr] = None
    resolution: Optional[Union[StrictFloat, StrictInt]] = None
    resolution_unit_uri: Optional[StrictStr] = None
    resolution_unit_name: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    aggregation_type_uri: Optional[StrictStr] = None
    aggregation_type_name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["measuring_range_min", "measuring_range_max", "failure_value", "accuracy", "label", "accuracy_unit_uri", "accuracy_unit_name", "unit_uri", "unit_name", "compartment_uri", "compartment_name", "property_uri", "property_name", "sampling_media_uri", "sampling_media_name", "resolution", "resolution_unit_uri", "resolution_unit_name", "created_at", "updated_at", "aggregation_type_uri", "aggregation_type_name", "description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RetrieveacollectionofDevicePropertyobjects0200ResponseDataInnerAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RetrieveacollectionofDevicePropertyobjects0200ResponseDataInnerAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "measuring_range_min": obj.get("measuring_range_min"),
            "measuring_range_max": obj.get("measuring_range_max"),
            "failure_value": obj.get("failure_value"),
            "accuracy": obj.get("accuracy"),
            "label": obj.get("label"),
            "accuracy_unit_uri": obj.get("accuracy_unit_uri"),
            "accuracy_unit_name": obj.get("accuracy_unit_name"),
            "unit_uri": obj.get("unit_uri"),
            "unit_name": obj.get("unit_name"),
            "compartment_uri": obj.get("compartment_uri"),
            "compartment_name": obj.get("compartment_name"),
            "property_uri": obj.get("property_uri"),
            "property_name": obj.get("property_name"),
            "sampling_media_uri": obj.get("sampling_media_uri"),
            "sampling_media_name": obj.get("sampling_media_name"),
            "resolution": obj.get("resolution"),
            "resolution_unit_uri": obj.get("resolution_unit_uri"),
            "resolution_unit_name": obj.get("resolution_unit_name"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "aggregation_type_uri": obj.get("aggregation_type_uri"),
            "aggregation_type_name": obj.get("aggregation_type_name"),
            "description": obj.get("description")
        })
        return _obj


