# coding: utf-8

"""
    Sensor Management System SMS

    REST API for managing sensor metadata. This API is based on {json:api} specification see: https://jsonapi.org/

    The version of the OpenAPI document: develop
    Contact: gitlab-incoming+hub-terra-sms-orchestration-3268-issue-@hzdr.de
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdatePlatform0RequestDataAttributes(BaseModel):
    """
    UpdatePlatform0RequestDataAttributes
    """ # noqa: E501
    description: Optional[StrictStr] = None
    short_name: Optional[StrictStr] = None
    long_name: Optional[StrictStr] = None
    manufacturer_uri: Optional[StrictStr] = None
    manufacturer_name: Optional[StrictStr] = None
    model: Optional[StrictStr] = None
    platform_type_uri: Optional[StrictStr] = None
    platform_type_name: Optional[StrictStr] = None
    status_uri: Optional[StrictStr] = None
    status_name: Optional[StrictStr] = None
    website: Optional[StrictStr] = None
    group_ids: Optional[List[StrictStr]] = None
    is_private: Optional[StrictBool] = None
    is_internal: Optional[StrictBool] = None
    is_public: Optional[StrictBool] = None
    keywords: Optional[List[StrictStr]] = None
    country: Optional[StrictStr] = None
    inventory_number: Optional[StrictStr] = None
    serial_number: Optional[StrictStr] = None
    persistent_identifier: Optional[StrictStr] = None
    schema_version: Optional[StrictStr] = None
    identifier_type: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["description", "short_name", "long_name", "manufacturer_uri", "manufacturer_name", "model", "platform_type_uri", "platform_type_name", "status_uri", "status_name", "website", "group_ids", "is_private", "is_internal", "is_public", "keywords", "country", "inventory_number", "serial_number", "persistent_identifier", "schema_version", "identifier_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdatePlatform0RequestDataAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdatePlatform0RequestDataAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "short_name": obj.get("short_name"),
            "long_name": obj.get("long_name"),
            "manufacturer_uri": obj.get("manufacturer_uri"),
            "manufacturer_name": obj.get("manufacturer_name"),
            "model": obj.get("model"),
            "platform_type_uri": obj.get("platform_type_uri"),
            "platform_type_name": obj.get("platform_type_name"),
            "status_uri": obj.get("status_uri"),
            "status_name": obj.get("status_name"),
            "website": obj.get("website"),
            "group_ids": obj.get("group_ids"),
            "is_private": obj.get("is_private"),
            "is_internal": obj.get("is_internal"),
            "is_public": obj.get("is_public"),
            "keywords": obj.get("keywords"),
            "country": obj.get("country"),
            "inventory_number": obj.get("inventory_number"),
            "serial_number": obj.get("serial_number"),
            "persistent_identifier": obj.get("persistent_identifier"),
            "schema_version": obj.get("schema_version"),
            "identifier_type": obj.get("identifier_type")
        })
        return _obj


