# SPDX-FileCopyrightText: 2020
# - Martin Abbrent <martin.abbrent@ufz.de>
# - Kotyba Alhaj Taha <kotyba.alhaj-taha@ufz.de>
# - Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)
#
# SPDX-License-Identifier: EUPL-1.2

# Generated by Django 3.0.11 on 2020-11-30 10:38

from django.db import migrations, models
import django.db.models.deletion
import django.db.models.expressions


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AggregationType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
            ],
            options={
                'db_table': 'aggregation_type',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Compartment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
            ],
            options={
                'db_table': 'compartment',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GlobalProvenance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('uri', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'db_table': 'global_provenance',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='MeasuredQuantity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('aggregation_type', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='measured_quantities', to='app.AggregationType')),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='measuredquantitys', to='app.GlobalProvenance')),
            ],
            options={
                'verbose_name_plural': 'measured quantities',
                'db_table': 'measured_quantity',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Unit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='units', to='app.GlobalProvenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.Unit')),
            ],
            options={
                'db_table': 'unit',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SamplingMedium',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('compartment', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='sampling_medium', to='app.Compartment')),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='samplingmediums', to='app.GlobalProvenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.SamplingMedium')),
            ],
            options={
                'verbose_name_plural': 'sampling media',
                'db_table': 'sampling_medium',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PlatformType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='platformtypes', to='app.GlobalProvenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.PlatformType')),
            ],
            options={
                'db_table': 'platform_type',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MeasuredQuantityUnit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('default_limit_min', models.DecimalField(blank=True, decimal_places=10, max_digits=19, null=True)),
                ('default_limit_max', models.DecimalField(blank=True, decimal_places=10, max_digits=19, null=True)),
                ('measured_quantity', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='measured_quantity_units', to='app.MeasuredQuantity')),
                ('unit', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='measured_quantity_units', to='app.Unit')),
            ],
            options={
                'db_table': 'measured_quantity_unit',
                'ordering': ['measured_quantity__term', 'unit__term'],
            },
        ),
        migrations.AddField(
            model_name='measuredquantity',
            name='sampling_medium',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='measured_quantities', to='app.SamplingMedium'),
        ),
        migrations.AddField(
            model_name='measuredquantity',
            name='successor',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.MeasuredQuantity'),
        ),
        migrations.CreateModel(
            name='Mapping',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='mappings', to='app.GlobalProvenance')),
            ],
            options={
                'db_table': 'mapping',
                'ordering': ['term'],
            },
        ),
        migrations.CreateModel(
            name='Manufacturer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='manufacturers', to='app.GlobalProvenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.Manufacturer')),
            ],
            options={
                'db_table': 'manufacturer',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EquipmentType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='equipmenttypes', to='app.GlobalProvenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.EquipmentType')),
            ],
            options={
                'db_table': 'equipment_type',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EquipmentStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='equipmentstatuss', to='app.GlobalProvenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.EquipmentStatus')),
            ],
            options={
                'verbose_name_plural': 'equipment status',
                'db_table': 'equipment_status',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='compartment',
            name='global_provenance',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='compartments', to='app.GlobalProvenance'),
        ),
        migrations.AddField(
            model_name='compartment',
            name='successor',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.Compartment'),
        ),
        migrations.AddField(
            model_name='aggregationtype',
            name='global_provenance',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='aggregationtypes', to='app.GlobalProvenance'),
        ),
        migrations.AddField(
            model_name='aggregationtype',
            name='successor',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.AggregationType'),
        ),
        migrations.AddConstraint(
            model_name='unit',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='unit_successor_not_a_reference_to_self'),
        ),
        migrations.AddConstraint(
            model_name='samplingmedium',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='samplingmedium_successor_not_a_reference_to_self'),
        ),
        migrations.AlterUniqueTogether(
            name='samplingmedium',
            unique_together={('term', 'compartment')},
        ),
        migrations.AddConstraint(
            model_name='platformtype',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='platformtype_successor_not_a_reference_to_self'),
        ),
        migrations.AlterUniqueTogether(
            name='measuredquantityunit',
            unique_together={('measured_quantity', 'unit')},
        ),
        migrations.AddConstraint(
            model_name='measuredquantity',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='measuredquantity_successor_not_a_reference_to_self'),
        ),
        migrations.AlterUniqueTogether(
            name='measuredquantity',
            unique_together={('term', 'sampling_medium')},
        ),
        migrations.AddConstraint(
            model_name='manufacturer',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='manufacturer_successor_not_a_reference_to_self'),
        ),
        migrations.AddConstraint(
            model_name='equipmenttype',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='equipmenttype_successor_not_a_reference_to_self'),
        ),
        migrations.AddConstraint(
            model_name='equipmentstatus',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='equipmentstatus_successor_not_a_reference_to_self'),
        ),
        migrations.AddConstraint(
            model_name='compartment',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='compartment_successor_not_a_reference_to_self'),
        ),
        migrations.AddConstraint(
            model_name='aggregationtype',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='aggregationtype_successor_not_a_reference_to_self'),
        ),
    ]
