# SPDX-FileCopyrightText: 2021
# - Jannes Breier <jannes.breier@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

# Generated by Django 3.0.13 on 2021-02-24 12:19

from django.db import migrations, models
import django.db.models.deletion
import django.db.models.expressions


class Migration(migrations.Migration):

    dependencies = [
        ('app', '0002_auto_20210112_0855'),
    ]

    operations = [
        migrations.CreateModel(
            name='ActionCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='actioncategorys', to='app.GlobalProvenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.ActionCategory')),
            ],
            options={
                'db_table': 'action_category',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ActionType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('term', models.CharField(max_length=255)),
                ('definition', models.TextField(blank=True, null=True)),
                ('provenance', models.CharField(blank=True, max_length=255, null=True)),
                ('provenance_uri', models.CharField(blank=True, max_length=255, null=True)),
                ('category', models.CharField(blank=True, max_length=255, null=True)),
                ('note', models.TextField(blank=True, null=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Rejected', 'Rejected'), ('Accepted', 'Accepted'), ('Archived', 'Archived'), ('Updated', 'Updated')], default='Pending', max_length=255)),
                ('action_category', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='action_types', to='app.ActionCategory')),
                ('global_provenance', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='actiontypes', to='app.GlobalProvenance')),
                ('successor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='app.ActionType')),
            ],
            options={
                'verbose_name_plural': 'action types',
                'db_table': 'action_type',
                'ordering': ['term'],
                'abstract': False,
            },
        ),
        migrations.AddConstraint(
            model_name='actiontype',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='actiontype_successor_not_a_reference_to_self'),
        ),
        migrations.AlterUniqueTogether(
            name='actiontype',
            unique_together={('term', 'action_category')},
        ),
        migrations.AddConstraint(
            model_name='actioncategory',
            constraint=models.CheckConstraint(check=models.Q(_negated=True, successor_id=django.db.models.expressions.F('id')), name='actioncategory_successor_not_a_reference_to_self'),
        ),
    ]
