# SPDX-FileCopyrightText: 2021
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

# Generated by Django 3.0.14 on 2021-06-08 10:51

from django.db import migrations, models
import django.db.models.deletion
import django.db.models.expressions


class Migration(migrations.Migration):

    dependencies = [
        ("app", "0006_auto_20210527_1924"),
    ]

    operations = [
        migrations.CreateModel(
            name="SoftwareType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="softwaretypes",
                        to="app.GlobalProvenance",
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="app.SoftwareType",
                    ),
                ),
            ],
            options={
                "db_table": "software_type",
                "ordering": ["term"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SoftwareTypeCommunity",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "community",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="app.Community",
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="software_types_communities",
                        to="app.SoftwareType",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "software types communities",
                "db_table": "software_type_community",
                "ordering": ["root__term", "term"],
                "abstract": False,
                "unique_together": {("root", "community")},
            },
        ),
        migrations.AddConstraint(
            model_name="softwaretype",
            constraint=models.CheckConstraint(
                check=models.Q(
                    _negated=True, successor_id=django.db.models.expressions.F("id")
                ),
                name="softwaretype_successor_not_a_reference_to_self",
            ),
        ),
    ]
