# SPDX-FileCopyrightText: 2021 - 2022
# - Kotyba Alhaj Taha <kotyba.alhaj-taha@ufz.de>
# - Jannes Breier <jannes.breier@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
# - Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)
#
# SPDX-License-Identifier: EUPL-1.2

from rest_framework_json_api.views import RelationshipView

from app.models import Community
from app.serializers.community_serializer import CommunitySerializer
from app.views.Base_viewset import BaseFilterViewSet


class CommunityViewSet(BaseFilterViewSet):
    """
    API endpoint that allows Community to be viewed or edited.
    """

    queryset = Community.objects.all()
    serializer_class = CommunitySerializer


class CommunityRelationshipView(RelationshipView):
    """
    view for relationships.community
    """

    queryset = Community.objects
    self_link_view_name = "community-relationships"
    http_method_names = ["get"]
