# SPDX-FileCopyrightText: 2022
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Marc Hanisch <marc.hanisch@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""empty message

Revision ID: 2a72092f5fd2
Revises: 35881b2a27d2
Create Date: 2022-10-26 11:12:44.911531

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "2a72092f5fd2"
down_revision = "6a6436214ad3"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "configuration_custom_field",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("key", sa.String(length=256), nullable=False),
        sa.Column("value", sa.String(length=1024), nullable=True),
        sa.Column("configuration_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["configuration_id"],
            ["configuration.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("configuration_custom_field")
    # ### end Alembic commands ###
