# SPDX-FileCopyrightText: 2024
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add persistent identifier field for sites.

Revision ID: 7a49c09c83e3
Revises: f23da62d05a9
Create Date: 2024-07-03 13:23:55.548144

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "7a49c09c83e3"
down_revision = "8d34f69823cc"
branch_labels = None
depends_on = None


def upgrade():
    """Do the database structure changes."""
    with op.batch_alter_table("site", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("persistent_identifier", sa.String(length=256), nullable=True)
        )
        batch_op.create_unique_constraint(None, ["persistent_identifier"])
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("site", schema=None) as batch_op:
        batch_op.drop_constraint(None, type_="unique")
        batch_op.drop_column("persistent_identifier")
    # ### end Alembic commands ###
