# SPDX-FileCopyrightText: 2024
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Add the model for the activity log.

Revision ID: 8d34f69823cc
Revises: f23da62d05a9
Create Date: 2024-07-04 11:20:57.181985

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "8d34f69823cc"
down_revision = "f23da62d05a9"
branch_labels = None
depends_on = None


def upgrade():
    """Run the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "activity_log",
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("entity", sa.String(length=256), nullable=False),
        sa.Column("entity_id", sa.Integer(), nullable=False),
        sa.Column("description", sa.String(length=256), nullable=True),
        sa.Column("data", sa.JSON(), nullable=True),
        sa.Column("created_by_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name="fk_ActivityLog_created_by_id",
            use_alter=True,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    """Undo the database structure changes."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("activity_log")
    # ### end Alembic commands ###
