# SPDX-FileCopyrightText: 2022
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""empty message

Revision ID: a12c9bcfbfdb
Revises: 0740d341ea8e
Create Date: 2022-05-30 10:43:06.475605

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "a12c9bcfbfdb"
down_revision = "0740d341ea8e"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("platform_unmount_action")
    op.drop_table("device_unmount_action")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "device_unmount_action",
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True
        ),
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column(
            "configuration_id", sa.INTEGER(), autoincrement=False, nullable=False
        ),
        sa.Column("device_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column(
            "end_date", postgresql.TIMESTAMP(), autoincrement=False, nullable=False
        ),
        sa.Column("description", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("contact_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("created_by_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("updated_by_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(
            ["configuration_id"],
            ["configuration.id"],
            name="device_unmount_action_configuration_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["contact_id"], ["contact.id"], name="device_unmount_action_contact_id_fkey"
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"], ["user.id"], name="fk_DeviceUnmountAction_created_by_id"
        ),
        sa.ForeignKeyConstraint(
            ["device_id"], ["device.id"], name="device_unmount_action_device_id_fkey"
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"], ["user.id"], name="fk_DeviceUnmountAction_updated_by_id"
        ),
        sa.PrimaryKeyConstraint("id", name="device_unmount_action_pkey"),
    )
    op.create_table(
        "platform_unmount_action",
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True
        ),
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column(
            "configuration_id", sa.INTEGER(), autoincrement=False, nullable=False
        ),
        sa.Column("platform_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column(
            "end_date", postgresql.TIMESTAMP(), autoincrement=False, nullable=False
        ),
        sa.Column("description", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("contact_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("created_by_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("updated_by_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(
            ["configuration_id"],
            ["configuration.id"],
            name="platform_unmount_action_configuration_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["contact_id"],
            ["contact.id"],
            name="platform_unmount_action_contact_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name="fk_PlatformUnmountAction_created_by_id",
        ),
        sa.ForeignKeyConstraint(
            ["platform_id"],
            ["platform.id"],
            name="platform_unmount_action_platform_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["updated_by_id"],
            ["user.id"],
            name="fk_PlatformUnmountAction_updated_by_id",
        ),
        sa.PrimaryKeyConstraint("id", name="platform_unmount_action_pkey"),
    )
    # ### end Alembic commands ###
