# SPDX-FileCopyrightText: 2022
# - Kotyba Alhaj Taha <kotyba.alhaj-taha@ufz.de>
# - Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)
#
# SPDX-License-Identifier: EUPL-1.2

"""Remove unused attributes from configutaion.

Revision ID: c608d8fec07d
Revises: a12c9bcfbfdb
Create Date: 2022-07-04 16:50:26.924455

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "c608d8fec07d"
down_revision = "91a9445513c0"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "configuration_latitude_src_device_property_id_fkey",
        "configuration",
        type_="foreignkey",
    )
    op.drop_constraint(
        "configuration_longitude_src_device_property_id_fkey",
        "configuration",
        type_="foreignkey",
    )
    op.drop_constraint(
        "configuration_elevation_src_device_property_id_fkey",
        "configuration",
        type_="foreignkey",
    )
    op.drop_column("configuration", "location_type")
    op.drop_column("configuration", "project_uri")
    op.drop_column("configuration", "project_name")
    op.drop_column("configuration", "longitude")
    op.drop_column("configuration", "elevation")
    op.drop_column("configuration", "longitude_src_device_property_id")
    op.drop_column("configuration", "latitude_src_device_property_id")
    op.drop_column("configuration", "latitude")
    op.drop_column("configuration", "elevation_src_device_property_id")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "configuration",
        sa.Column(
            "elevation_src_device_property_id",
            sa.INTEGER(),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "configuration",
        sa.Column(
            "latitude",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "configuration",
        sa.Column(
            "latitude_src_device_property_id",
            sa.INTEGER(),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "configuration",
        sa.Column(
            "longitude_src_device_property_id",
            sa.INTEGER(),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "configuration",
        sa.Column(
            "elevation",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "configuration",
        sa.Column(
            "longitude",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "configuration",
        sa.Column(
            "project_name", sa.VARCHAR(length=256), autoincrement=False, nullable=True
        ),
    )
    op.add_column(
        "configuration",
        sa.Column(
            "project_uri", sa.VARCHAR(length=256), autoincrement=False, nullable=True
        ),
    )
    op.add_column(
        "configuration",
        sa.Column(
            "location_type", sa.VARCHAR(length=256), autoincrement=False, nullable=True
        ),
    )
    op.create_foreign_key(
        "configuration_elevation_src_device_property_id_fkey",
        "configuration",
        "device_property",
        ["elevation_src_device_property_id"],
        ["id"],
    )
    op.create_foreign_key(
        "configuration_longitude_src_device_property_id_fkey",
        "configuration",
        "device_property",
        ["longitude_src_device_property_id"],
        ["id"],
    )
    op.create_foreign_key(
        "configuration_latitude_src_device_property_id_fkey",
        "configuration",
        "device_property",
        ["latitude_src_device_property_id"],
        ["id"],
    )
    # ### end Alembic commands ###
