# SPDX-FileCopyrightText: 2023
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2

# Generated by Django 4.1.8 on 2023-04-13 08:54

"""Migration to add the licenses to the CV."""

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    """Migration to add the licenses to the CV."""

    dependencies = [
        ("app", "0019_sitetype_siteusage_sitetypecommunity_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="License",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)ss",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="app.license",
                    ),
                ),
            ],
            options={
                "db_table": "license",
                "ordering": ["term"],
                "abstract": False,
            },
        ),
        migrations.AddConstraint(
            model_name="license",
            constraint=models.CheckConstraint(
                check=models.Q(("successor_id", models.F("id")), _negated=True),
                name="license_successor_not_a_reference_to_self",
            ),
        ),
    ]
