# SPDX-FileCopyrightText: 2023 - 2024
# - Nils Brinckmann <nils.brinckmann@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
#
# SPDX-License-Identifier: EUPL-1.2
# Generated by Django 4.2.5 on 2024-01-10 15:33

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("app", "0020_license_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalUnitCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.unit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical unit community",
                "verbose_name_plural": "historical units communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalUnit",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.unit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical unit",
                "verbose_name_plural": "historical units",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSoftwareTypeCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.softwaretype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical software type community",
                "verbose_name_plural": "historical software types communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSoftwareType",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.softwaretype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical software type",
                "verbose_name_plural": "historical software types",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSiteUsageCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.siteusage",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical site usage community",
                "verbose_name_plural": "historical site usage communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSiteUsage",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.siteusage",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical site usage",
                "verbose_name_plural": "historical site usages",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSiteTypeCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.sitetype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical site type community",
                "verbose_name_plural": "historical site types communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSiteType",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site_usage",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.siteusage",
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.sitetype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical site type",
                "verbose_name_plural": "historical site types",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSamplingMediumCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "compartment",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.compartment",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.samplingmedium",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical sampling medium community",
                "verbose_name_plural": "historical sampling media communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSamplingMedium",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "compartment",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.compartment",
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.samplingmedium",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical sampling medium",
                "verbose_name_plural": "historical sampling media",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalPlatformTypeCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.platformtype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical platform type community",
                "verbose_name_plural": "historical platform types communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalPlatformType",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.platformtype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical platform type",
                "verbose_name_plural": "historical platform types",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMeasuredQuantityUnit",
            fields=[
                ("id", models.IntegerField(blank=True, db_index=True)),
                (
                    "default_limit_min",
                    models.DecimalField(
                        blank=True, decimal_places=10, max_digits=19, null=True
                    ),
                ),
                (
                    "default_limit_max",
                    models.DecimalField(
                        blank=True, decimal_places=10, max_digits=19, null=True
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "measured_quantity",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.measuredquantity",
                    ),
                ),
                (
                    "unit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.unit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical measured quantity unit",
                "verbose_name_plural": "historical measured quantity units",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMeasuredQuantityCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "aggregation_type",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.aggregationtype",
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.measuredquantity",
                    ),
                ),
                (
                    "sampling_media",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.samplingmedium",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical measured quantity community",
                "verbose_name_plural": "historical measured quantity communitys",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMeasuredQuantity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "aggregation_type",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.aggregationtype",
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "sampling_media",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.samplingmedium",
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.measuredquantity",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical measured quantity",
                "verbose_name_plural": "historical measured quantities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalManufacturerCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.manufacturer",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical manufacturer community",
                "verbose_name_plural": "historical manufacturer communitys",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalManufacturer",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.manufacturer",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical manufacturer",
                "verbose_name_plural": "historical manufacturers",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalLicense",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.license",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical license",
                "verbose_name_plural": "historical licenses",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalGlobalProvenance",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(db_index=True, max_length=255)),
                (
                    "description",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("uri", models.CharField(blank=True, max_length=255, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical global provenance",
                "verbose_name_plural": "historical global provenances",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalEquipmentTypeCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.equipmenttype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical equipment type community",
                "verbose_name_plural": "historical equipment types communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalEquipmentType",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.equipmenttype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical equipment type",
                "verbose_name_plural": "historical equipment types",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalEquipmentStatusCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.equipmentstatus",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical equipment status community",
                "verbose_name_plural": "historical equipment status communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalEquipmentStatus",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.equipmentstatus",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical equipment status",
                "verbose_name_plural": "historical equipment status",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalCountry",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("iso_code", models.CharField(max_length=3)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.country",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical country",
                "verbose_name_plural": "historical Countries",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalContactRoleCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.contactrole",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical contact role community",
                "verbose_name_plural": "historical contact role communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalContactRole",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.contactrole",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Contact role",
                "verbose_name_plural": "historical Contact roles",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalCompartmentCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.compartment",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical compartment community",
                "verbose_name_plural": "historical compartments communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalCompartment",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.compartment",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical compartment",
                "verbose_name_plural": "historical compartments",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical community",
                "verbose_name_plural": "historical communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAggregationTypeCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.aggregationtype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical aggregation type community",
                "verbose_name_plural": "historical aggregation types communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAggregationType",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.aggregationtype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical aggregation type",
                "verbose_name_plural": "historical aggregation types",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalActionTypeCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_category",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.actioncategory",
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.actiontype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical action type community",
                "verbose_name_plural": "historical action types communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalActionType",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_category",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.actioncategory",
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.actiontype",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical action type",
                "verbose_name_plural": "historical action types",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalActionCategoryCommunity",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "abbreviation",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("note", models.TextField(blank=True, null=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "community",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.community",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.actioncategory",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical action category community",
                "verbose_name_plural": "historical action categories communities",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalActionCategory",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("term", models.CharField(max_length=255)),
                ("definition", models.TextField(blank=True, null=True)),
                ("provenance", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "provenance_uri",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("category", models.CharField(blank=True, max_length=255, null=True)),
                ("note", models.TextField(blank=True, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("PENDING", "Pending"),
                            ("REJECTED", "Rejected"),
                            ("ACCEPTED", "Accepted"),
                            ("ARCHIVED", "Archived"),
                            ("UPDATED", "Updated"),
                        ],
                        default="PENDING",
                        max_length=255,
                    ),
                ),
                (
                    "requested_by_email",
                    models.CharField(
                        blank=True,
                        max_length=512,
                        null=True,
                        verbose_name="Requested by",
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "global_provenance",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.globalprovenance",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="app.actioncategory",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical action category",
                "verbose_name_plural": "historical action categories",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
