# SPDX-FileCopyrightText: 2021 - 2022
# - Kotyba Alhaj Taha <kotyba.alhaj-taha@ufz.de>
# - Jannes Breier <jannes.breier@gfz-potsdam.de>
# - Helmholtz Centre Potsdam - GFZ German Research Centre for Geosciences (GFZ, https://www.gfz-potsdam.de)
# - Helmholtz Centre for Environmental Research GmbH - UFZ (UFZ, https://www.ufz.de)
#
# SPDX-License-Identifier: EUPL-1.2

from rest_framework_json_api.views import RelationshipView

from ..models import ActionCategory
from ..serializers.actioncategory_serializer import ActionCategorySerializer
from ..views.Base_viewset import BaseFilterViewSet, text_rels, usual_rels

filterset_fields = {
    "id": usual_rels,
    "term": text_rels + usual_rels,
    "definition": text_rels + usual_rels,
    "provenance": text_rels + usual_rels,
    "provenance_uri": text_rels + usual_rels,
    "category": text_rels + usual_rels,
    "status": text_rels + usual_rels,
    "note": text_rels + usual_rels,
    "action_types__term": text_rels + usual_rels,
    "global_provenance__name": text_rels + usual_rels,
}


class ActionCategoryViewSet(BaseFilterViewSet):
    """
    API endpoint that allows Action Categories to be viewed or edited.
    """

    queryset = ActionCategory.objects.all()
    serializer_class = ActionCategorySerializer
    filterset_fields = filterset_fields


class ActionCategoryRelationshipView(RelationshipView):
    """
    view for relationships.action_category
    """

    queryset = ActionCategory.objects
    self_link_view_name = "action_category-relationships"
    http_method_names = ["get"]
