% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiSNE.R
\name{multiSNE}
\alias{multiSNE}
\title{Multi-SNE: Multi-view t-SNE}
\usage{
multiSNE(
  X,
  initial_config = NULL,
  k = 2,
  initial_dims = 30,
  perplexity = 30,
  max_iter = 1000,
  min_cost = 0,
  epoch_callback = NULL,
  whitening = FALSE,
  epoch = 100,
  weights = NULL,
  weightUpdating = TRUE,
  lambdaParameter = 1
)
}
\arguments{
\item{X}{A list with each element representing a data-view. All data-views must have the same number of rows.}

\item{initial_config}{Initialization matrix, specifying the initial embedding for each data-view. Should be a list of the same length as X. Default is NULL.}

\item{k}{Number of dimensions in the latent embeddings. Default is 2.}

\item{initial_dims}{The number of dimensions of the whitened data-views, if whitening True. Default is 30.}

\item{perplexity}{Value of perplexity parameter. Default is 30.}

\item{max_iter}{Maximum number of iterations to run. Default is 1000.}

\item{min_cost}{Minimum cost to halt iteration Default is 0.}

\item{epoch_callback}{A callback function used after each epoch (an epoch here means a set number of iterations). Default is NULL.}

\item{whitening}{If True, whitening process to reduce the dimensions of the input data-views will be applied prior to multi-SNE. Default is FALSE.}

\item{epoch}{The number of iterations in between update messages. Default is 100.}

\item{weights}{Initialization of the weights. A vector of the same length as X. Default is NULL.}

\item{weightUpdating}{Boolean. If True, weights will be updated at each iteration. Default is FALSE.}

\item{lambdaParameter}{Parameter to indicate the contribution of weight update. Default is 1.}
}
\value{
Y : The latent embeddings.

Weights : A matrix containing the weights used for each iteration. Rows represent the iteration and columns the data-view.

Errors : A matrix containing the errors used for each iteration. Rows represent the iteration and columns the data-view.
}
\description{
This function performs multi-SNE, a visualisation algorithm for multi-view data.
}
\examples{
# Get sample data
X <- vector("list")
X$first_dataView <- rbind(matrix(rnorm(10000),nrow=500,ncol=20), matrix(rnorm(5000, mean=1,sd=2),nrow=250,ncol=20))
X$second_dataView <- rbind(matrix(rpois(20000, lambda = 1),nrow=500,40), matrix(rpois(10000, lambda=3),250,40))
# Run multi-SNE
Y <- multiSNE(X)
plot(Y$Y, col = c(rep(1,500), rep(2,250)))

}
\keyword{dimensionality}
\keyword{multisne,}
\keyword{nonlinear}
\keyword{reduction,}
\keyword{tsne,}
\keyword{visualisation,}
