% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSNE.R
\name{tSNE}
\alias{tSNE}
\title{The t-SNE method for dimensionality reduction}
\usage{
tSNE(
  X,
  initial_config = NULL,
  k = 2,
  initial_dims = 30,
  perplexity = 30,
  max_iter = 1000,
  min_cost = 0,
  epoch_callback = NULL,
  whitening = FALSE,
  epoch = 100
)
}
\arguments{
\item{X}{The R matrix or "dist" object}

\item{initial_config}{An argument providing a matrix specifying the initial embedding for X. See Default is NULL.}

\item{k}{The dimension of the resulting embedding. Default is 2.}

\item{initial_dims}{The number of dimensions to use in reduction method, if whitening True. Default is 30.}

\item{perplexity}{Perplexity parameter. (optimal number of neighbors). Default is 30.}

\item{max_iter}{Maximum number of iterations to perform. Default is 1000.}

\item{min_cost}{The minimum cost value (error) to halt iteration. Default is 0.}

\item{epoch_callback}{A callback function used after each epoch (an epoch here means a set number of iterations). Default is NULL.}

\item{whitening}{A boolean value indicating whether the matrix data should be whitened. Default is FALSE.}

\item{epoch}{The number of iterations in between update messages. Default is 100.}
}
\value{
ydata : An R object containing a ydata embedding matrix, as well as a the matrix of probabilities P
}
\description{
This function is copied from the tsne package found in CRAN.
Provides a simple function inteface for specifying t-SNE dimensionality reduction on R matrices or "dist" objects.
}
\examples{
## Not run: 
colors = rainbow(length(unique(iris$Species)))
names(colors) = unique(iris$Species)
ecb = function(x,y){ plot(x,t='n'); text(x,labels=iris$Species, col=colors[iris$Species]) }
tsne_iris = tsne(iris[,1:4], epoch_callback = ecb, perplexity=50)

# compare to PCA
dev.new()
pca_iris = princomp(iris[,1:4])$scores[,1:2]
plot(pca_iris, t='n')
text(pca_iris, labels=iris$Species,col=colors[iris$Species])

}
\keyword{dimensionality}
\keyword{multisne,}
\keyword{nonlinear}
\keyword{reduction,}
\keyword{tsne,}
\keyword{visualisation,}
